<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Order;
use App\Models\Expense;
use App\Models\Withdraw;
use App\Models\FootPrint;
use App\Models\ExpenseType;
use App\Models\ServiceType;
use App\Models\Subscription;
use App\Models\WorksDetails;
use Illuminate\Http\Request;
use App\Models\PaymentMethod;
use App\Models\BudgetReceived;
use App\Models\EmployeeSalary;
use App\Models\SubscriptionType;
use App\Models\ClientRefundRequest;
use App\Models\SubscriptionPayment;
use Illuminate\Support\Facades\Auth;

class PermanentDelete extends Controller
{
    public function User($fid,$id)
    {
        User::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "User deleted Parmanently";
        $fData->user_id = $id;
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'User deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function Order($fid,$id)
    {
        Order::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "Order deleted Parmanently";
        $fData->order_id = $id;
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'Order deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function Assign($fid,$id)
    {
        User::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "Assign deleted Parmanently";
        $fData->assign_id = $id;
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'Assign deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function WorksDetails($fid,$id)
    {
        WorksDetails::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "WorksDetails deleted Parmanently";
        $fData->works_details_id = $id;
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'WorksDetails deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function OrderSummary($fid,$id)
    {
        User::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "OrderSummary deleted Parmanently";
        $fData->order_summary_id = $id;
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'OrderSummary deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function Transection($fid,$id)
    {
        User::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "Transection deleted Parmanently";
        $fData->transection_id = $id;
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'Transection deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function ServiceType($fid,$id)
    {
        ServiceType::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "ServiceType deleted Parmanently";
        $fData->service_type_id = $id;
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'ServiceType deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function RiskFund($fid,$id)
    {
        User::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "RiskFund deleted Parmanently";
        $fData->risk_fund_id = $id;
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'RiskFund deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function ExpenseType($fid,$id)
    {
        ExpenseType::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "ExpenseType deleted Parmanently";
        $fData->expense_type_id = $id;
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'ExpenseType deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function Expense($fid,$id)
    {
        Expense::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "Expense deleted Parmanently";
        $fData->expense_id = $id;
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'Expense deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }



    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //                          Kamrul Function Start
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~


    public function ClientRefundRequest($fid,$id)
    {
        ClientRefundRequest::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "ClientRefundRequest";
        $fData->table_id = $id;
        $fData->comment = "Client Refund Request Deleted Parmanently";
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'Client Refund Request Deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function BudgetReceived($fid,$id)
    {
        BudgetReceived::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "BudgetReceived";
        $fData->table_id = $id;
        $fData->comment = "Budget Received Deleted Parmanently";
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'Budget Received Deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function Withdraw($fid,$id)
    {
        Withdraw::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "Withdraw";
        $fData->table_id = $id;
        $fData->comment = "Withdraw Deleted Parmanently";
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'Withdraw Deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function SubscriptionPayment($fid,$id)
    {
        SubscriptionPayment::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "SubscriptionPayment";
        $fData->table_id = $id;
        $fData->comment = "Subscription Payment Deleted Parmanently";
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'Subscription Payment Deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function Subscription($fid,$id)
    {
        Subscription::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "Subscription";
        $fData->table_id = $id;
        $fData->comment = "Subscription Deleted Parmanently";
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'Subscription Deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function EmployeeSalary($fid,$id)
    {
        EmployeeSalary::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "EmployeeSalary";
        $fData->table_id = $id;
        $fData->comment = "Employee Salary Deleted Parmanently";
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'Employee Salary Deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function SubscriptionType($fid,$id)
    {
        SubscriptionType::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "SubscriptionType";
        $fData->table_id = $id;
        $fData->comment = "Subscription Type Deleted Parmanently";
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'Subscription Type Deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function PaymentMethods($fid,$id)
    {
        PaymentMethod::find($id)->delete();
        FootPrint::find($fid)->delete();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "PaymentMethod";
        $fData->table_id = $id;
        $fData->comment = "Payment Method Deleted Parmanently";
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'Payment Method Deleted Parmanently !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //                          Kamrul Function End
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

}
