<?php

namespace App\Http\Controllers;

use App\Models\BudgetReceived;
use App\Models\User;
use App\Models\Order;
use App\Models\Expense;
use App\Models\FootPrint;
use App\Models\ExpenseType;
use App\Models\ServiceType;
use App\Models\WorksDetails;
use Illuminate\Http\Request;
use App\Models\ClientRefundRequest;
use App\Models\EmployeeSalary;
use App\Models\PaymentMethod;
use App\Models\Subscription;
use App\Models\SubscriptionPayment;
use App\Models\SubscriptionType;
use App\Models\Withdraw;
use Illuminate\Support\Facades\Auth;

class RestoreController extends Controller
{
    public function User($fid,$id)
    {
        User::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

            $fData = new Footprint();
            $fData->operator_id = Auth::user()->id;
            $fData->comment = "User Restored";
            $fData->user_id = $id;
            $fData->status = 6;
            $fData->save();

        $notification= array(
            'message' =>'User Restored !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function Order($fid,$id)
    {
        Order::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "Order Restored ";
        $fData->order_id = $id;
        $fData->status = 6;
        $fData->save();

        $notification= array(
            'message' =>'Order Restored  !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
    public function Assign($fid,$id)
    {
        User::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "Assign Restored ";
        $fData->assign_id = $id;
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'Assign Restored  !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
    public function WorksDetails($fid,$id)
    {
        WorksDetails::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "WorksDetails Restored ";
        $fData->works_details_id = $id;
        $fData->status = 6;
        $fData->save();

        $notification= array(
            'message' =>'WorksDetails Restored  !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
    public function OrderSummary($fid,$id)
    {
        User::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "OrderSummary Restored ";
        $fData->order_summary_id = $id;
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'OrderSummary Restored  !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
    public function Transection($fid,$id)
    {
        User::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "Transection Restored ";
        $fData->transection_id = $id;
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'Transection Restored  !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
    public function ServiceType($fid,$id)
    {
        ServiceType::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);
        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "ServiceType Restored ";
        $fData->service_type_id = $id;
        $fData->status = 6;
        $fData->save();

        $notification= array(
            'message' =>'ServiceType Restored  !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
    public function RiskFund($fid,$id)
    {
        User::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "RiskFund Restored ";
        $fData->risk_fund_id = $id;
        $fData->status = 5;
        $fData->save();

        $notification= array(
            'message' =>'RiskFund Restored !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
    public function ExpenseType($fid,$id)
    {
        ExpenseType::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "ExpenseType Restored ";
        $fData->expense_type_id = $id;
        $fData->status = 6;
        $fData->save();

        $notification= array(
            'message' =>'ExpenseType Restored !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
    public function Expense($fid,$id)
    {
        Expense::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->comment = "Expense Restored ";
        $fData->expense_id = $id;
        $fData->status = 6;
        $fData->save();

        $notification= array(
            'message' =>'Expense Restored !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }




    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //                          Kamrul Function Start
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    public function ClientRefundRequest($fid,$id)
    {
        ClientRefundRequest::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "ClientRefundRequest";
        $fData->table_id = $id;
        $fData->comment = "Client Refund Request Restored";
        $fData->status = 6;
        $fData->save();

        $notification= array(
            'message' =>'Client Refund Request Restored !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    public function BudgetReceived($fid,$id)
    {
        BudgetReceived::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "BudgetReceived";
        $fData->table_id = $id;
        $fData->comment = "Budget Received Restored";
        $fData->status = 6;
        $fData->save();

        $notification= array(
            'message' =>'Budget Received Restored !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }


    public function Withdraw($fid,$id)
    {
        Withdraw::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "Withdraw";
        $fData->table_id = $id;
        $fData->comment = "Withdraw Restored";
        $fData->status = 6;
        $fData->save();

        $notification= array(
            'message' =>'Withdraw Restored !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }


    public function SubscriptionPayment($fid,$id)
    {
        SubscriptionPayment::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "SubscriptionPayment";
        $fData->table_id = $id;
        $fData->comment = "SubscriptionPayment Restored";
        $fData->status = 6;
        $fData->save();

        $notification= array(
            'message' =>'SubscriptionPayment Restored !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }


    public function Subscription($fid,$id)
    {
        Subscription::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "Subscription";
        $fData->table_id = $id;
        $fData->comment = "Subscription Restored";
        $fData->status = 6;
        $fData->save();

        $notification= array(
            'message' =>'Subscription Restored !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }


    public function EmployeeSalary($fid,$id)
    {
        EmployeeSalary::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "EmployeeSalary";
        $fData->table_id = $id;
        $fData->comment = "Employee Salary Restored";
        $fData->status = 6;
        $fData->save();

        $notification= array(
            'message' =>'Employee Salary Restored !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }


    public function SubscriptionType($fid,$id)
    {
        SubscriptionType::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "SubscriptionType";
        $fData->table_id = $id;
        $fData->comment = "Subscription Type Restored";
        $fData->status = 6;
        $fData->save();

        $notification= array(
            'message' =>'Subscription Type Restored !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }


    public function PaymentMethods($fid,$id)
    {
        PaymentMethod::where('id',$id)->update([
            'status'=>2
        ]);
        FootPrint::where('id',$fid)->update([
           'status'=>7
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "PaymentMethod";
        $fData->table_id = $id;
        $fData->comment = "Payment Method Restored";
        $fData->status = 6;
        $fData->save();

        $notification= array(
            'message' =>'Payment Method Restored !!!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }

    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //                          Kamrul Function End
    // ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

}
