<?php

namespace App\Http\Controllers\accounts\administration;

use App\Models\User;
use App\Models\Accounts;
use App\Models\Transaction;
use App\Models\Subscription;
use Illuminate\Http\Request;
use App\Models\PaymentMethod;
use App\Models\EmployeeSalary;
use App\Models\SubscriptionType;
use Illuminate\Support\Facades\DB;
use App\Models\SubscriptionPayment;
use App\Http\Controllers\Controller;
use App\Models\VendorPayment;

class AdministrationController extends Controller
{
    public function index()
    {
        $accountsTotal = Accounts::first();
        // dd($accountsTotal->total);
        $findEmployee = User::whereIn('status', [1,2,3])->whereIn('role', [2,5,6])->get();

        $findVendor = DB::table('assign_tables')
                    ->select('users.name as vendorName','users.role as role','assign_tables.*')
                    ->join('users','assign_tables.ven_Emp_id','=','users.id')
                    ->groupBy('assign_tables.ven_Emp_id')
                    ->get();
        // dd($findVendor);
        $getVendorSalary = VendorPayment::whereIn('status', [1,2])->orderBy('id','desc')->get();

        $findEmployeeSalary = EmployeeSalary::whereIn('status', [1,2])->orderBy('trans_date', 'DESC')->get();

        $findPaymentMethods = PaymentMethod::whereIn('status', [1,2])->get();

        $findSubscription = Subscription::whereIn('status', [1,2])->orderBy('id','desc')->get();
        $findSubsType = SubscriptionType::whereIn('status', [1,2])->get();

        $findSalary = Transaction::where('trans_type', 4)->whereIn('status', [1,2])->get();
        
        // dd($findSubscription);
        
        return view('admin.page.accounts.administration.payTo.payTo', get_defined_vars());
    }

}
