<?php

namespace App\Http\Controllers\accounts\administration;

use App\Models\User;
use App\Models\Accounts;
use App\Models\FootPrint;
use App\Models\Transaction;
use Illuminate\Http\Request;
use App\Models\EmployeeSalary;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class EmployeeSalaryController extends Controller
{
    public function findEmployeeSalary(Request $request)
    {
        // http://127.0.0.1:8000/findEmployeeSalary?_token=7LMEOLlimPIPXPXnmpdPa1qqE8ohcyQtjNzeTCJg&emplyID=1
        $findEmpSalary = User::where('id', $request->emplyID)->first();
        echo json_encode($findEmpSalary);
    }

    public function store(Request $request)
    {
        // dd($request->all());
        $validator=Validator::make($request->all(), [
            'employee_id' => 'required',
            'salary' => 'required',
            'trans_date' => 'required',
            'payment_method_id' => 'required',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'Please Check Error Message !!!',
                'alert-type'=>'error'
            );
            return back()->with($notification);
        } else {


            $start_date = $request->month_of_salary;
            $date = strtotime($start_date);
            $dataDetails = date('Y-m-d', $date);
            // dd($dataDetails);

            $data = new EmployeeSalary();
            $data->transactionID = $request->transactionID;
            $data->employee_id = $request->employee_id;
            $data->salary = $request->salary;
            $data->trans_date= $request->trans_date;
            $data->payment_method_id= $request->payment_method_id;
            $data->note = $request->note;
            $data->month_of_salary = $dataDetails;

            if ($request->bonus != null ) {
                $data->bonus = $request->bonus;
                $data->total_salary = $request->salary + $request->bonus;
            }else{
                $data->bonus = 0;
                $data->total_salary = $request->salary;
            }

            $data->created_by = Auth::user()->id;
            $data->created_date = Carbon::now();
            $data->status = 1;
            $data->save();
            // dd($data);

            $saveTrans = new Transaction();
            $saveTrans->trans_type = 4;
            $saveTrans->amount = $data->total_salary;
            $saveTrans->date= $request->trans_date;
            $saveTrans->employee_salaries_id = $data->id;
            $saveTrans->employee_id = $request->employee_id;
            $saveTrans->note = $request->note;
            $saveTrans->created_by = Auth::user()->id;
            $saveTrans->created_date = Carbon::now();
            $saveTrans->status = 1;
            $saveTrans->save();
            // dd($saveTrans);

            $accountsTotal = Accounts::first();
            $totalDebit = $accountsTotal->debit + $data->total_salary;
            $totalAmount = $accountsTotal->total - $data->total_salary;

            // dd($totalDebit);

            Accounts::find(1)->update([
                'debit'=> $totalDebit,
                'total'=> $totalAmount,
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "EmployeeSalary";
            $fData->table_id = $data->id;
            $fData->comment = "Employee Salary Added";
            $fData->status = 1;
            $fData->save();

            $notification= array(
                'message' =>'Employee Salary given Successfully',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }
    }

    public function findEmployeeSalaryID(Request $request)
    {
        // http://127.0.0.1:8000/findEmployeeSalaryID?_token=7LMEOLlimPIPXPXnmpdPa1qqE8ohcyQtjNzeTCJg&salryID=1
        // $findEmployeeSalaryID = EmployeeSalary::where('id', $request->salryID)->first();
        $findEmployeeSalaryID = DB::table('employee_salaries')
                    ->select('users.id as employeeID', 'users.name as employeeName', 'payment_methods.name as payMethod','employee_salaries.*')
                    ->join('users','employee_salaries.employee_id','=','users.id')
                    ->join('payment_methods','employee_salaries.payment_method_id','=','payment_methods.id')
                    ->where('employee_salaries.id', $request->salryID)
                    ->first();

        echo json_encode($findEmployeeSalaryID);
    }


    public function update(Request $request)
    {

        $findData = EmployeeSalary::where('id', $request->id)->first();

        if($findData != null){

            if(is_numeric($request->payment_method_id)){
                $paymentMethodId = $request->payment_method_id;
                // echo "req->id" ;
            }else{
                $paymentMethodId = $findData->payment_method_id;
                // echo "db->id" ;
            }
            // dd($request->all());

            if($request->bonus > 0){
                $totalSalary = $findData->salary + $request->bonus;
            }else{
                $totalSalary = $findData->salary;
            }

            if($request->month_of_salary != null ){
                $start_date = $request->month_of_salary;
                $date = strtotime($start_date);
                $dataDetails = date('Y-m-d', $date);
            }else{
                $dataDetails = $findData->month_of_salary;
            }
            // dd($dataDetails);

            EmployeeSalary::find($request->id)->update([
                'transactionID'=> $request->transactionID,
                'month_of_salary'=> $dataDetails,
                'bonus'=> $request->bonus,
                'total_salary'=> $totalSalary,
                'payment_method_id'=> $paymentMethodId,
                'trans_date'=> $request->trans_date,
                'note'=> $request->note,
                'status'=> 2,
                'updated_by'=>Auth::user()->id,
                'updated_date'=>Carbon::now()
            ]);

            Transaction::where('employee_salaries_id', $findData->id)->update([
                'amount'=> $totalSalary,
                'note'=> $request->note,

                'status'=> 2,
                'updated_by'=>Auth::user()->id,
                'updated_date'=>Carbon::now()
            ]);

            $accountsTotal = Accounts::first();
            $totalDebit = ($accountsTotal->debit - $findData->total_salary) + $totalSalary;
            $totalAmount = ($accountsTotal->total + $findData->total_salary) - $totalSalary;

            // dd($totalDebit);

            Accounts::find(1)->update([
                'debit'=> $totalDebit,
                'total'=> $totalAmount,
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "EmployeeSalary";
            $fData->table_id = $request->id;
            $fData->comment = "Employee Salary Updated";
            $fData->status = 2;
            $fData->save();

            $notification= array(
                'message' =>'Employee Salary Updated Successfully !',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }else{
            return view('admin.404');
        }
    }

    public function destroy($id)
    {
        $findData = EmployeeSalary::where('id', $id)->first();
        // dd($id);

        if($findData != null){
            EmployeeSalary::find($id)->update([
                'status'=> 0,
                'deleted_by'=>Auth::user()->id,
                'deleted_date'=>Carbon::now()
            ]);

            Transaction::where('employee_salaries_id', $findData->id)->update([
                'status'=> 0,
                'deleted_by'=>Auth::user()->id,
                'deleted_date'=>Carbon::now()
            ]);

            $accountsTotal = Accounts::first();
            $totalDebit = ($accountsTotal->debit - $findData->amount);
            $totalAmount = ($accountsTotal->total + $findData->amount);

            Accounts::find(1)->update([
                'debit'=> $totalDebit,
                'total'=> $totalAmount,
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "EmployeeSalary";
            $fData->table_id = $id;
            $fData->comment = "Employee Salary Deleted";
            $fData->status = 0;
            $fData->save();

            $notification= array(
                'message' =>'Employee Salary Deleted Successfully !',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }else{
            return view('admin.404');
        }
    }
}
