<?php

namespace App\Http\Controllers\accounts\administration;

use App\Models\Order;
use App\Models\Accounts;
use App\Models\FootPrint;
use App\Models\SpendMoney;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Models\ClientRefundRequest;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth; 

class ManageRefundController extends Controller
{
    public function index()
    {
        $getRefundData = ClientRefundRequest::whereIn('status', [1,2])->get();
        return view('admin.page.accounts.administration.manageRefund.clientRefund', get_defined_vars());
    }

    public function payClientsRefundRequest($id)
    {
        // dd($id);
        $getData = ClientRefundRequest::where('id', $id)->first();

        if($getData != null){
            ClientRefundRequest::where('id', $id)->update([
                'status'=> 2,
                'refund_status'=> 1,
                'updated_by'=>Auth::user()->id,
                'updated_date'=>Carbon::now()
            ]);

            $findData = ClientRefundRequest::where('id', $id)->first();
            $findOrder = Order::where('id', $findData->order_id)->first();
            $findSpendMoney = SpendMoney::where('order_id', $findData->order_id)->where('client_id', $findData->client_id)->first();

            if($findOrder->total_due < 0){

                $totalPay = $findOrder->total_pay - $findData->request_amount ;
                $totalDue = $findOrder->total_due + $findData->request_amount ;
                Order::where('id', $findData->order_id)->update([
                    'total_pay'=> $totalPay,
                    'total_due'=> $totalDue
                ]);

                $paymentAmounts = $findSpendMoney->payment_amount - $findData->request_amount;
                $receivedAmounts = $findSpendMoney->total_received_amount - $findData->request_amount;

                // dd($receivedAmounts);
                
                SpendMoney::where('order_id', $findData->order_id)->where('client_id', $findData->client_id)->update([
                    'payment_amount'=> $paymentAmounts,
                    'total_received_amount'=> $receivedAmounts
                ]);
            }

            $saveTrans = new Transaction();
            $saveTrans->client_refund_req_id = $findData->id;
            $saveTrans->trans_type = 9;
            $saveTrans->amount = $findData->request_amount;
            $saveTrans->date= $findData->req_date;

            $saveTrans->created_by = Auth::user()->id;
            $saveTrans->created_date = Carbon::now();
            $saveTrans->status = 1;
            $saveTrans->save();
            // dd($saveTrans);

            $accountsTotal = Accounts::first();
            $totalDebit = $accountsTotal->debit + $findData->request_amount;
            $totalAmount = $accountsTotal->total - $findData->request_amount;

            // dd($totalDebit);

            Accounts::find(1)->update([
                'debit'=> $totalDebit,
                'total'=> $totalAmount,
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "ClientRefundRequest";
            $fData->table_id = $id;
            $fData->comment = "Client Refund Request Completed";
            $fData->status = 1;
            $fData->save();

            $notification= array(
                'message' =>'Refund Request Completed Successfully',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }else{
            return view('admin.404');
        }
    }

}
