<?php

namespace App\Http\Controllers\accounts\administration;

use App\Models\Accounts;
use App\Models\FootPrint;
use App\Models\Subscription;
use Illuminate\Http\Request;
use App\Models\PaymentMethod;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use App\Models\SubscriptionPayment;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class SubscriptionController extends Controller
{
    public function store(Request $request)
    {
        // dd($request->all());
        $validator = Validator::make($request->all(), [
            'subscription_type_id' => 'required',
            'amount' => 'required',
            'billing_date' => 'required',
            'alert_date' => 'required',
            'alert_status' => 'required',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'Please Check Error Message !!!',
                'alert-type'=>'error'
            );
            return back()->with($notification);
        } else {

            $data = new Subscription();
            $data->subscription_type_id = $request->subscription_type_id;
            $data->amount = $request->amount;
            $data->billing_date= $request->billing_date;
            $data->alert_date= $request->alert_date;
            $data->alert_status = $request->alert_status;
            $data->note = $request->note;

            $data->created_by = Auth::user()->id;
            $data->created_date = Carbon::now();
            $data->status = 1;
            $data->save();
            // dd($data);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "Subscription";
            $fData->table_id = $data->id;
            $fData->comment = "Subscription Added";
            $fData->status = 1;
            $fData->save();

            $notification= array(
                'message' =>'Subscription Added Successfully',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }
    }

    public function details($id)
    {
        $accountsTotal = Accounts::first();
        $findSub = Subscription::where('id', $id)->first();
        $findPaymentMethods = PaymentMethod::whereIn('status', [1,2])->get();
        $findSubPaymment = SubscriptionPayment::where('subscription_id', $id)->whereIn('status', [1,2])->get();
        // dd($findSubPaymment);
        if($findSub != null){
            return view('admin.page.accounts.administration.payTo.subscription.subscriptionDetails', get_defined_vars());
        }else{
            return view('admin.404');
        }
    }

    public function findSubscriptionID(Request $request)
    {
        // http://127.0.0.1:8000/findSubscriptionID?_token=7LMEOLlimPIPXPXnmpdPa1qqE8ohcyQtjNzeTCJg&subsId=1
        // $findSubscriptionID = EmployeeSalary::where('id', $request->subsId)->first();
        $findSubscriptionID = DB::table('subscriptions')
                    ->select('subscription_types.name as subsTypeName','subscriptions.*')
                    ->join('subscription_types','subscriptions.subscription_type_id','=','subscription_types.id')
                    ->where('subscriptions.id', $request->subsId)
                    ->first();

        echo json_encode($findSubscriptionID);
    }

    public function update(Request $request)
    {
        $findSubs = Subscription::where('id', $request->id)->first();

        if($findSubs != null){

            if(is_numeric($request->subscription_type_id)){
                $subs_type_id = $request->subscription_type_id;
                // echo "req->id" ;
            }else{
                $subs_type_id = $findSubs->subscription_type_id;
                // echo "db->id" ;
            }

            if(is_numeric($request->alert_status)){
                $alrtStatus = $request->alert_status;
                // echo "req->status" ;
            }else{
                $alrtStatus = $findSubs->alert_status;
                // echo "db->status" ;
            }

            // dd($alrtStatus);

            Subscription::find($request->id)->update([
                'subscription_type_id'=> $subs_type_id,
                'amount'=> $request->amount,
                'billing_date'=> $request->billing_date,
                'alert_date'=> $request->alert_date,
                'alert_status'=> $alrtStatus,
                'note'=> $request->note,

                'status'=> 2,
                'updated_by'=>Auth::user()->id,
                'updated_date'=>Carbon::now()
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "Subscription";
            $fData->table_id = $request->id;
            $fData->comment = "Subscription Updated";
            $fData->status = 2;
            $fData->save();

            $notification= array(
                'message' =>'Subscription Updated Successfully !',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }else{
            return view('admin.404');
        }

    }

    public function destroy($id)
    {
        $getData = Subscription::find($id)->first();

        if($getData != null){
            Subscription::find($id)->update([
                'status'=> 0,
                'deleted_by'=>Auth::user()->id,
                'deleted_date'=>Carbon::now()
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "Subscription";
            $fData->table_id = $id;
            $fData->comment = "Subscription Deleted";
            $fData->status = 0;
            $fData->save();

            $notification= array(
                'message' =>'Subscription Deleted Successfully !',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }else{
            return view('admin.404');
        }
    }
}
