<?php

namespace App\Http\Controllers\accounts\client;

use App\Models\Order;
use App\Models\FootPrint;
use App\Models\WorksDetails;
use Illuminate\Http\Request;
use App\Models\PaymentMethod;
use Illuminate\Support\Carbon;
use App\Models\ClientRefundRequest;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class ClientRefundRequestController extends Controller
{
    public function index()
    {
        $getRefundData = ClientRefundRequest::whereIn('status', [1,2])->get();
        $payMethod = PaymentMethod::whereIn('status', [1,2])->get();
        $findOrder = Order::where('order_creator_id', Auth::user()->id)
                    ->where('order_status', 7)
                    ->whereIn('status', [1,2,3])
                    // ->where('total_pay', '>', 0)
                    ->get();

        return view('admin.page.accounts.client.client_refund', get_defined_vars());
    }

    public function getOrderDetails(Request $request)
    {
        // http://127.0.0.1:8000/getOrderDetails?_token=7LMEOLlimPIPXPXnmpdPa1qqE8ohcyQtjNzeTCJg&findID=1

        $getOrderDetails = Order::where('id', $request->findID)->first();

        // dd($getOrderDetails);

        echo json_encode($getOrderDetails);
    }

    public function getTotalWorks(Request $request)
    {
        // http://127.0.0.1:8000/getTotalWorks?_token=7LMEOLlimPIPXPXnmpdPa1qqE8ohcyQtjNzeTCJg&findID=1

        $getTotalWorks = WorksDetails::where('order_id', $request->findID)->whereIn('work_details_status', [1,2])->whereIn('status', [1,2,3,4,5])->count();

        echo json_encode($getTotalWorks);
    }

    public function getTotalCost(Request $request)
    {
        // http://127.0.0.1:8000/getTotalWorks?_token=7LMEOLlimPIPXPXnmpdPa1qqE8ohcyQtjNzeTCJg&findID=1

        $getOrderDetails = Order::where('id', $request->findID)->first();

        $getTotalWorks = WorksDetails::where('order_id', $request->findID)->whereIn('work_details_status', [1,2])->whereIn('status', [1,2,3,4,5])->count();

        $workRate = $getOrderDetails->service_cost;

        $totalCost = $getTotalWorks * $workRate;

        echo json_encode($totalCost);
    }

    public function getTotalRefundAmount(Request $request)
    {
        // http://127.0.0.1:8000/getTotalWorks?_token=7LMEOLlimPIPXPXnmpdPa1qqE8ohcyQtjNzeTCJg&findID=1

        $getOrderDetails = Order::where('id', $request->findID)->first();

        $getTotalWorks = WorksDetails::where('order_id', $request->findID)->whereIn('work_details_status', [1,2])->whereIn('status', [1,2,3,4,5])->count();

        $workRate = $getOrderDetails->service_cost;
        $total_pay = $getOrderDetails->total_pay;

        $totalCost = $getTotalWorks * $workRate;

        $remainAmount = $total_pay - $totalCost ;

        echo json_encode($remainAmount);
    }

    public function store(Request $request)
    {
        // dd($request->all());
        $validator=Validator::make($request->all(), [
            'order_id' => 'required',
            'client_id' => 'required',
            'service_type_id' => 'required',
            'payment_method_id' => 'required',
            'request_amount' => 'required',
            'req_date' => 'required',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'Please Check Error Message !!!',
                'alert-type'=>'error'
            );
            return back()->with($notification);
        } else {

            $data = new ClientRefundRequest();
            $data->order_id = $request->order_id;
            $data->client_id = $request->client_id;
            $data->service_type_id = $request->service_type_id;
            $data->payment_method_id = $request->payment_method_id;

            $data->quantity = $request->quantity;
            $data->rate = $request->rate;
            $data->total_budget = $request->total_budget;
            $data->total_work = $request->total_work;
            $data->total_cost = $request->total_cost;

            $data->request_amount= $request->request_amount;
            $data->req_date= $request->req_date;
            $data->refund_status= $request->refund_status;
            $data->note = $request->note;

            $data->created_by = Auth::user()->id;
            $data->created_date = Carbon::now();
            $data->status = 1;
            $data->save();
            // dd($data);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "RefundRequest";
            $fData->table_id = $data->id;
            $fData->comment = "Refund Request Added";
            $fData->status = 1;
            $fData->save();

            $notification= array(
                'message' =>'Refund Request Send Successfully',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }

    }

    public function update(Request $request, $id)
    {
        //
    }

    public function destroy($id)
    {
        // dd($id);
        $getData =  ClientRefundRequest::where('id', $id)->first();
        if($getData != null){
            ClientRefundRequest::where('id', $id)->update([
                'status'=> 0,
                'deleted_by'=>Auth::user()->id,
                'deleted_date'=>Carbon::now()
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "ClientRefundRequest";
            $fData->table_id = $id;
            $fData->comment = "Client Refund Request Deleted";
            $fData->status = 0;
            $fData->save();

            $notification= array(
                'message' =>'Client Refund Request Deleted Successfully !',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }else{
            return view('admin.404');
        }
    }
}
