<?php

namespace App\Http\Controllers\accounts\vendor;

use App\Http\Controllers\Controller;
use App\Models\FootPrint;
use App\Models\PaymentMethod;
use App\Models\Transaction;
use App\Models\VendorAccount;
use App\Models\VendorBudgetReceived;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;

class VendorBudgetReceiveController extends Controller
{
    public function index()
    {
        $getBudgetReceived = VendorBudgetReceived::whereIn('status', [1,2,3,4])->where('received_by',Auth::user()->id)->orderBy('id','desc')->get();
        $findPaymentMethods = PaymentMethod::whereIn('status', [1,2])->get();

        return view('admin.page.accounts.vendor.budgetReceived.budgetReceived', get_defined_vars());
    }

    public function store(Request $request)
    {
        // dd($request->all());
        $validator = Validator::make($request->all(), [
            'payment_method_id' => 'required',
            'received_amount' => 'required',
            'trans_date' => 'nullable',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'Please Check Error Message !!!',
                'alert-type'=>'error'
            );
            return back()->with($notification);
        } else {

            $data = new VendorBudgetReceived();
            // $data->trnx_id = $request->trnx_id;
            $data->payment_method_id = $request->payment_method_id;
            $data->received_amount = $request->received_amount;
            // $data->trans_date = $request->trans_date;
            $data->note = $request->note;
            $data->received_by = Auth::user()->id;

            $data->created_by = Auth::user()->id;
            $data->created_date = Carbon::now();
            $data->status = 3;
            $data->save();

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "VendorBudgetReceived";
            $fData->table_id = $data->id;
            $fData->comment = "Budget Received Added";
            $fData->status = 1;
            $fData->save();

            $notification= array(
                'message' =>'Budget Received Successfully Done.',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }
    }

    public function update(Request $request)
    {
        if(Auth()->user()->role == 1 || Auth()->user()->role == 2){
            $validator = Validator::make($request->all(), [
                'payment_method_id' => 'nullable',
                'received_amount' => 'required',
                'trans_date' => 'required',
            ]);

        } else {
            $validator = Validator::make($request->all(), [
                'payment_method_id' => 'nullable',
                'received_amount' => 'required',
            ]);
        }

        if ($validator->fails()) {
            $notification= array(
                'message' =>'Please Check Error Message !!!',
                'alert-type'=>'error'
            );
            return back()->with($notification);
        } else {

            $data = VendorBudgetReceived::find($request->id);
            $request->trnx_id ? $data->trnx_id = $request->trnx_id : '';
            $request->payment_method_id ? $data->payment_method_id = $request->payment_method_id : '';
            $data->received_amount = $request->received_amount;
            $data->trans_date = $request->trans_date;
            $request->note ? $data->note = $request->note : '';
            // $data->received_by = Auth::user()->id;

            $data->updated_by = Auth::user()->id;
            $data->updated_date = Carbon::now();

            $data->save();

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "VendorBudgetReceived";
            $fData->table_id = $data->id;
            $fData->comment = "Budget Received Update";
            $fData->status = 2;
            $fData->save();

            if(Auth()->user()->role == 1 || Auth()->user()->role == 2)
            {
                $data = VendorBudgetReceived::find($request->id);
                $data ->status         = 2;
                $data ->updated_by     = Auth::user()->id;
                $data ->updated_date   = Carbon::now();
                $data->save();


                $saveTrans = new Transaction();
                $saveTrans->budget_received_id = $data->id;
                $saveTrans->trans_type = 1;
                $saveTrans->amount = $data->received_amount;
                $saveTrans->date= $data->trans_date;
                $saveTrans->note = $data->note;
                $saveTrans->created_by = $data->created_by;
                $saveTrans->created_date = Carbon::now();
                $saveTrans->status = 1;
                $saveTrans->save();
                // dd($saveTrans);

                $vendorAccount = VendorAccount::where('balance_holder', $data->received_by)->first();
                if($vendorAccount)
                {
                    $vendorAccount->current_balance += $data->received_amount;
                    $vendorAccount->save();
                }else{
                    VendorAccount::create([
                        'balance_holder' => $data->received_by,
                        'current_balance' => $data->received_amount,
                    ]);
                }

                $fData = new FootPrint();
                $fData->operator_id = Auth::user()->id;
                $fData->table_name = "VendorBudgetReceived";
                $fData->table_id = $data->id;
                $fData->comment = "Budget Received Active";
                $fData->status = 3;
                $fData->save();

                $notification= array(
                    'message' =>'Budget Received Accept Successfully !',
                    'alert-type'=>'success'
                );
            } else {
                $notification= array(
                    'message' =>'Budget Received Successfully Updated.',
                    'alert-type'=>'success'
                );
            }

            return back()->with($notification);
        }
    }

    public function findBudgtRecID(Request $request)
    {
        $findWithdraw = VendorBudgetReceived::where('id', $request->budgetRId)->first();
        if($findWithdraw->payment_method_id != null)
        {
            $findBudgtRecID = DB::table('vendor_budget_receiveds')
                        ->select('payment_methods.name as payMethodName','vendor_budget_receiveds.*')
                        ->join('payment_methods','vendor_budget_receiveds.payment_method_id','=','payment_methods.id')
                        ->where('vendor_budget_receiveds.id', $request->budgetRId)
                        ->first();
        }else{
            $findBudgtRecID = VendorBudgetReceived::where('id', $request->budgetRId)->first();
        }

        echo json_encode($findBudgtRecID);
    }

    public function destroy($id)
    {
        $findData = VendorBudgetReceived::where('id', $id)->first();
        // dd($id);
        VendorBudgetReceived::find($id)->update([
            'status'=> 0,
            'deleted_by'=>Auth::user()->id,
            'deleted_date'=>Carbon::now()
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->table_name = "BudgetReceived";
        $fData->table_id = $id;
        $fData->comment = "Budget Received Deleted";
        $fData->status = 0;
        $fData->save();

        $notification= array(
            'message' =>'Budget Received Deleted Successfully !',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
}
