<?php

namespace App\Http\Controllers\admin;

use App\Models\User;
use App\Models\FootPrint;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class AdminProfileController extends Controller
{
   
    public function index()
    {
        $data = User::where('id',Auth::user()->id)->whereIn('status',[1,2,3])->first();
        //dd($data);
        return view('admin.profile.viewProfile',get_defined_vars());
    }

    public function update(Request $request, $id)
    {
          //dd($request->all());
          $this->validate($request,[
            'name' => 'required',
            'phone' => 'required',
            'address' => 'required',
            'gender' => 'required',
        ]);

        $data=User::find($id);
        $data->name=$request->name;
        $data->gender=$request->gender;
        $data->phone=$request->phone;
        $data->gender=$request->gender;
        $data->address=$request->address;
        if($request->dob !=null){
            $data->dob = date('Y-m-d',strtotime($request->dob));
        }
        $data->status = 2;
        if($request->file('image')){
            $file=$request->file('image');
                @unlink(public_path('upload/userImage/'.$data->image));
                $filename=date('YmdHi').$file->getClientOriginalName();
                $file->move(public_path('upload/userImage'),$filename);
                $data['image']=$filename;
        }
        $data->save();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->user_id = $id;
        $fData->comment = "Profile Updated";
        $fData->status = 2;
        $fData->save();

        $notification= array(
            'message' =>'Profile Updated successfully',
            'alert-type'=>'success'
        );
        return Redirect()->route('profile')->with($notification);
    }
    
    public function updatePassword(Request $request,$id)
    {
        $data=User::find($id);
        $data->password=  bcrypt($request->password);
        $data->pass_code=$request->password;
        $data->save();

        $notification= array(
            'message' =>'Password Updated successfully ...!',
            'alert-type'=>'success'
        );

        if($data->id !=null){

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->user_id = $id;
        $fData->comment = "Password Updated";
        $fData->status = 2;
        $fData->save();

        $notification= array(
            'message' =>'Password Updated successfully',
            'alert-type'=>'success'
        );
    }else{
        $notification= array(
            'message' =>'Password Not Updated Inserted !!!',
            'alert-type'=>'error'
        );

    }
        return Redirect()->route('profile')->with($notification);
    }
    
    public function destroy($id)
    {
        //
    }
}
