<?php

namespace App\Http\Controllers\admin;

use Exception;
use App\Models\User;
use App\Models\Config;
use App\Models\FootPrint;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class ManageUserController extends Controller
{
   
    public function index()
    {
        return view('admin.page.manageUsers.manageUsers');
    }

  
    public function viewActive()
    {
        $users = User::whereIn('status',[1,2,3])->whereIn('role',[2,3,4,5,6])->get();
        //dd($users);
        return view('admin.page.manageUsers.allActiveUsers',get_defined_vars());
    }

    
    public function findUsers(Request $request)
    {
        if($request->a_id ==3)
        {
            if($request->id ==1)
            {
                $users = User::whereIn('status',[1,2,3])->whereIn('role',[2,3,4,5,6])->get();
            }
            else if($request->id ==3)
            {
                $users = User::whereIn('status',[1,2,3])->where('role',3)->get();
            }
            else if($request->id ==2)
            {
                $users = User::whereIn('status',[1,2,3])->where('role',2)->get();
            }
            else if($request->id ==4)
            {
                $users = User::whereIn('status',[1,2,3])->where('role',4)->get();
            }
            else if($request->id ==5)
            {
                $users = User::whereIn('status',[1,2,3])->where('role',5)->get();
            }
            else if($request->id ==6)
            {
                $users = User::whereIn('status',[1,2,3])->where('role',6)->get();
            }

        }
        else if($request->a_id == 4){

            if($request->id ==1)
            {
                $users = User::where('status',4)->whereIn('role',[2,3,4,5,6])->get();
            }
            else if($request->id ==3)
            {
                $users = User::where('status',4)->where('role',3)->get();
            }
            else if($request->id ==2)
            {
                $users = User::where('status',4)->where('role',2)->get();
            }
            else if($request->id ==4)
            {
                $users = User::where('status',4)->where('role',4)->get();
            }
            else if($request->id ==5)
            {
                $users = User::where('status',4)->where('role',5)->get();
            }
            else if($request->id ==6)
            {
                $users = User::where('status',4)->where('role',6)->get();
            }
        }
        
        echo json_encode($users);

    }

    
    public function editUser($id)
    {
        $data = User::find($id);
        return view('admin.page.manageUsers.editUser',get_defined_vars());
    }
   
    public function updateUser(Request $request, $id)
    {
         //dd($request->all());
         $this->validate($request,[
            'name' => 'required',
            'phone' => 'required',
            'address' => 'required',
            'gender' => 'required',

        ]);

        $data=User::find($id);

        $data->name=$request->name;
        $data->gender=$request->gender;
        $data->phone=$request->phone;
        $data->gender=$request->gender;
        $data->address=$request->address;
        if($request->dob !=null){
            $data->dob = date('Y-m-d',strtotime($request->dob));
        }
        $data->status = 2;
        if($request->file('image')){
            $file=$request->file('image');

                @unlink(public_path('upload/userImage/'.$data->image));
                $filename=date('YmdHi').$file->getClientOriginalName();
                $file->move(public_path('upload/userImage'),$filename);
                $data['image']=$filename;
        }
        $data->save();


        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->user_id = $id;
        if($data->role == 3)
        {
            $fData->comment = "Client Profile Updated";
        }
        else if($data->role == 4)
        {
            $fData->comment = "Vendor Profile Updated";
        }
        else if($data->role == 5)
        {
            $fData->comment = "Employee Profile Updated";
        }
        
        $fData->status = 2;
        $fData->save();

        $notification= array(
            'message' =>'Profile Updated successfully',
            'alert-type'=>'success'
        );
        return Redirect()->route('viewActive')->with($notification);
    }
  
    public function ActiveUser($id)
    {
        //dd($id);
        User::where('id',$id)->update([
            'status'=>3,
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->user_id = $id;
        $fData->comment = "Active User";
        $fData->status = 3;
        $fData->save();
        $notification= array(
            'message' =>'Active User Successfully',
            'alert-type'=>'success'
        );
            return Redirect()->back()->with($notification);
    }

    public function storeIsDark(Request $request)
    {
        abort_unless(auth()->user(), 404);


        User::where('id', auth()->id())->update([
            'is_dark_mode' => $request->is_dark,
        ]);

        return response()->json([
            'is_dark' => auth()->user()->is_dark_mode
        ]);
    }
    
    


    // Blocked Keywords
    public function blockedKeywords()
    {
        return view('admin.page.systemConfig.blocked_keywords.index', [
            'values' => Config::getDropdown('key_words'),
        ]);
    }

    public function updateBlockedKeywords(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|max:255'
        ]);

        $values = Config::getDropdown('key_words');
        
        if (in_array($request->name, $values)) {
            $notification = array(
                'message' =>'Already exists.',
                'alert-type'=>'error'
            );

            return back()->with($notification);
        }

        $name = strtolower($request->name);

        $values[] = $resStr = str_replace(' ', '-', $name);
        $result = self::updateConfig('key_words', json_encode($values, true));

        if ($result) {
            $notification = array(
                'message' =>'Added Successfully.',
                'alert-type'=>'success'
            );

            return back()->with($notification);
        }

        $notification = array(
            'message' =>'Opps! something went wrong...',
            'alert-type'=>'error'
        );

        return back()->with($notification);
    }

    public function updateConfig(string $key, string $value)
    {
        try {
            $config = Config::firstOrNew(['key' => $key]);
            $config->value = $value;
            $config->save();

            $notification = array(
                'message' =>'Added Successfully.',
                'alert-type'=>'success'
            );

            return back()->with($notification);
        } catch (Exception $e) {
            Log::error($e->getMessage());

            return back();
        }
    }

    public function deleteBlockedKeyword($id)
    {
        $values = Config::getDropdown('key_words');
        array_splice($values, intval($id), 1);

        $result = self::updateConfig('key_words', json_encode($values, true));

        if ($result) {
            $notification = array(
                'message' =>'Deleted Successfully.',
                'alert-type'=>'success'
            );

            return back()->with($notification);
        }

        $notification = array(
            'message' =>'Opps! something went wrong...',
            'alert-type'=>'error'
        );

        return back()->with($notification);
    }
}
