<?php

namespace App\Http\Controllers\admin;

use App\Models\User;
use App\Models\FootPrint;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class ManageVendorController extends Controller
{
   
    public function active()
    {
        $vendors = User::where('role', 4)->whereIn('status',[1,2,3])->get();
        //dd($clients);
        return view('admin.page.vendor.activeVendor',get_defined_vars());
        
    }

    public function inactive()
    {
        $vendors = User::where('role', 4)->where('status',4)->get();
        //dd($clients);
        return view('admin.page.vendor.inactiveVendor',get_defined_vars());
    }

    public function all()
    {
        $vendors = User::where('role', 4)->where('status','!=',0)->get();
        //dd($clients);
        return view('admin.page.vendor.allVendor',get_defined_vars());
    }



    public function addVendor()
    {
        return view('admin.page.vendor.addVendor',get_defined_vars());
    }
    

    public function store(Request $request)
    {
        $this->validate($request,[
            'name' => 'required',
            'email' => 'required|unique:users',
            'password' => 'required',
        ]);
       
         //dd($request->all());
            $user = new User();
            $user->name = $request->name;
            $user->phone = $request->phone;
            $user->email = $request->email;
            $user->gender = $request->gender;
            $user->role = 4;
            $user->password = bcrypt($request->password);
            $user->pass_code = $request->password;
            $user->address = $request->address;
            if($request->dob !=null){
                $user->dob = date('Y-m-d',strtotime($request->dob));
                }
            if ($request->file('image')) {
                $file = $request->file('image');
                $filename = date('YmdHi').$file->getClientOriginalName();
                $file->move(public_path('upload/userImage'),$filename);
                $user['image'] = $filename;
            }

            $user->status = 1;
            $user->created_by = Auth::user()->id;
            $user->created_date = Carbon::now();
            $user->save();

            if($user->id !=null){
                $fData = new FootPrint();
                $fData->operator_id = Auth::user()->id;
                $fData->user_id = $user->id;
                $fData->comment = "Vendor Inserted";
                $fData->status = 1;
                $fData->save();

                $notification= array(
                    'message' =>'Vendor Inserted Successfully ',
                    'alert-type'=>'success'
                );
            }else{
                $notification= array(
                    'message' =>'Vendor Not Inserted !!!',
                    'alert-type'=>'error'
                );

            }
            return redirect()->route('view-active-vendor')->with($notification);
    }

    public function editVendor($id)
    {
        $data = User::find($id);
        return view('admin.page.vendor.editVendor',get_defined_vars());
    }

    public function updateVendor(Request $request, $id)
    {
         //dd($request->all());
         $this->validate($request,[
            'name' => 'required',
            'phone' => 'required',
            'address' => 'required',
            'gender' => 'required',

        ]);

        $data=User::find($id);

        $data->name=$request->name;
        $data->gender=$request->gender;
        $data->phone=$request->phone;
        $data->gender=$request->gender;
        $data->address=$request->address;
        $data->updated_by=Auth::user()->id;
        $data->updated_date=Carbon::now();
        if($request->dob !=null){
            $data->dob = date('Y-m-d',strtotime($request->dob));
        }
        $data->status = 2;
        if($request->file('image')){
            $file=$request->file('image');

                @unlink(public_path('upload/userImage/'.$data->image));
                $filename=date('YmdHi').$file->getClientOriginalName();
                $file->move(public_path('upload/userImage'),$filename);
                $data['image']=$filename;
        }
        $data->save();

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->user_id = $id;
        $fData->comment = "Vendor Profile Updated";
        $fData->status = 2;
        $fData->save();

        $notification= array(
            'message' =>'Vendor Profile Updated successfully',
            'alert-type'=>'success'
        );
        return Redirect()->route('view-active-vendor')->with($notification);
    }

    public function InactiveVendor($id)
    {
        //dd($id);
        User::where('id',$id)->update([
            'status'=>4,
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->user_id = $id;
        $fData->comment = "Inactive User";
        $fData->status = 4;
        $fData->save();
        $notification= array(
            'message' =>'InActive Vendor Successfully',
            'alert-type'=>'success'
        );
            return Redirect()->back()->with($notification);
    }

    public function ActiveVendor($id)
    {
        //dd($id);
        User::where('id',$id)->update([
            'status'=>3,
        ]);
         $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->user_id = $id;
        $fData->comment = "Active Vendor";
        $fData->status = 3;
        $fData->save();
        $notification= array(
            'message' =>'Active Vendor Successfully',
            'alert-type'=>'success'
        );
            return Redirect()->back()->with($notification);
    }

    public function DistroyVendor($id)
    {
        //dd($id);
        User::where('id',$id)->update([
            'status'=>0,
        ]);

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->user_id = $id;
        $fData->comment = "Vendor Deleted";
        $fData->status = 0;
        $fData->save();

        $notification= array(
            'message' =>'Vendor Deleted Successfully',
            'alert-type'=>'success'
        );
            return Redirect()->back()->with($notification);
    }
}
