<?php

namespace App\Http\Controllers\admin\systemConfig;

use App\Models\FootPrint;
use App\Models\ExpenseType;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class ExpenseTypeController extends Controller
{
    public function findExpense(Request $request)
    {
        $getData=ExpenseType::where('id',$request->id)->first();
        //alert($getData);
        echo json_encode($getData);
    }
    
    public function index()
    {
        $datas = ExpenseType::whereIn('status',[1,2,3])->get();
        return view('admin.page.systemConfig.expense.expenseType',get_defined_vars());
    }
   
    public function store(Request $request)
    {
        //dd($request->all());
        $data = new ExpenseType();
        $data->name =  $request->name;
        $data->status = 1;
        $data->created_by = Auth::user()->id;
        $data->created_date = Carbon::now();
        $data->save();

        if($data->id !=null){
        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->expense_type_id = $data->id;
        $fData->comment = "Expense Type Inserted";
        $fData->status = 1;
        $fData->save();


        $notification= array(
            'message' =>'Expense Type Inserted Successfully ',
            'alert-type'=>'success'
        );
        }else{
            $notification= array(
                'message' =>'Expense Type Not Inserted !!!',
                'alert-type'=>'error'
            );

        }
            return redirect()->route('view-expense')->with($notification);
    }
  
    public function update(Request $request)
    {
        //dd($request->all());
        $data = ExpenseType::find($request->id);
        $data->name =  $request->name;
        $data->status = 2;
        $data->updated_by = Auth::user()->id;
        $data->updated_date = Carbon::now();
        $data->save();

        if($data->id !=null){
        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->expense_type_id = $data->id;
        $fData->comment = "Expense Type Updated";
        $fData->status = 2;
        $fData->save();


        $notification= array(
            'message' =>'Expense Type Updated Successfully',
            'alert-type'=>'success'
        );

        }else{
            $notification= array(
                'message' =>'Expense Type Not Updated !!!',
                'alert-type'=>'error'
            );

        }
        return redirect()->route('view-expense')->with($notification);
    }

 
    public function destroy($id)
    {
        $data = ExpenseType::find($id);
        $data->status = 0;
        $data->deleted_by = Auth::user()->id;
        $data->deleted_date = Carbon::now();
        $data->save();

        if($data->id !=null){

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->expense_type_id = $id;
        $fData->comment = "Expense Type Deleted";
        $fData->status = 0;
        $fData->save();

        $notification= array(
            'message' =>'Expense Type Deleted Successfully ',
            'alert-type'=>'success'
        );
        }else{
            $notification= array(
                'message' =>'Expense Type Not Inserted !!!',
                'alert-type'=>'error'
            );
        }
            return redirect()->route('view-expense')->with($notification);
    }
}
