<?php

namespace App\Http\Controllers\admin\systemConfig;

use App\Models\Expense;
use App\Models\Accounts;
use App\Models\FootPrint;
use App\Models\ExpenseType;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class GeneralExpenseController extends Controller
{
    public function findGenExpense(Request $request)
    {
        $getData=Expense::where('id',$request->id)->first();
        //alert($getData);
        echo json_encode($getData);
    }

    public function index()
    {
        $expType = ExpenseType::whereIn('status',[1,2,3])->get();
        $datas = Expense::whereIn('status',[1,2,3])->orderBy('id', 'DESC')->get();
        $accountsTotal = Accounts::first();
        return view('admin.page.systemConfig.expense.generalExpense',get_defined_vars());
    }

    public function store(Request $request)
    {
        // dd($request->all());
        $data = new Expense();
        $data->expense_type_id =  $request->expense_type_id;
        $data->transactionID =  $request->transactionID;
        $data->date =  $request->date;
        $data->amount =  $request->amount;
        $data->reason =  $request->reason;
        $data->status = 1;
        $data->created_by = Auth::user()->id;
        $data->created_date = Carbon::now();
        $data->save();

        if($data->id !=null){
            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->expense_id = $data->id;
            $fData->comment = "Expense Inserted";
            $fData->status = 1;
            $fData->save();

            $saveTrans = new Transaction();
            $saveTrans->trans_type = 3;
            $saveTrans->amount = $data->amount;
            $saveTrans->date= $request->trans_date;
            $saveTrans->expense_id = $data->id;
            $saveTrans->note = $request->reason;
            $saveTrans->created_by = Auth::user()->id;
            $saveTrans->created_date = Carbon::now();
            $saveTrans->status = 1;
            $saveTrans->save();
            // dd($saveTrans);

            $accountsTotal = Accounts::first();
            $totalDebit = $accountsTotal->debit + $data->amount;
            $totalAmount = $accountsTotal->total - $data->amount;

            // dd($totalDebit);

            Accounts::find(1)->update([
                'debit'=> $totalDebit,
                'total'=> $totalAmount,
            ]);

            $notification= array(
                'message' =>'Expense Saved Successfully ',
                'alert-type'=>'success'
            );
        }else{
            $notification= array(
                'message' =>'Expense Not Saved !!!',
                'alert-type'=>'error'
            );

        }
        return redirect()->route('general-expense')->with($notification);
    }
    public function edit($id)
    {
        $expType = ExpenseType::whereIn('status',[1,2,3])->get();
        $data = Expense::find($id);
        //dd($data);

        return view('admin.page.systemConfig.expense.editGeneralExp',get_defined_vars());
    }
    public function update(Request $request, $id)
    {
        //dd($request->all());
        $getExpense = Expense::where('id', $request->id)->first();

        $data = Expense::find($request->id);
        $data->expense_type_id =  $request->expense_type_id;
        $data->transactionID =  $request->transactionID;
        $data->date =  $request->date;
        $data->amount =  $request->amount;
        $data->reason =  $request->reason;
        $data->status = 2;
        $data->updated_by = Auth::user()->id;
        $data->updated_date = Carbon::now();
        $data->save();

        if($data->id !=null){
            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->expense_id = $id;
            $fData->comment = "General Expense Updated";
            $fData->status = 2;
            $fData->save();

            Transaction::where('expense_id', $data->id)->update([
                'amount' => $data->amount,
                'updated_by' => Auth::user()->id,
                'updated_date' => Carbon::now(),
                'status' => 2,
            ]);
            // dd($saveTrans);

            $accountsTotal = Accounts::first();
            $totalDebit = ($accountsTotal->debit - $getExpense->amount) + $data->amount;
            $totalAmount = ($accountsTotal->total + $getExpense->amount) - $data->amount;

            // dd($totalDebit);

            Accounts::find(1)->update([
                'debit'=> $totalDebit,
                'total'=> $totalAmount,
            ]);

            $notification= array(
                'message' =>'General Expense Updated Successfully',
                'alert-type'=>'success'
            );
        }else{
            $notification= array(
                'message' =>'General Expense Not Updated !!!',
                'alert-type'=>'error'
            );

        }
            return redirect()->route('general-expense')->with($notification);
    }


    public function destroy($id)
    {
        $getExpense = Expense::where('id', $id)->first();

        $data = Expense::find($id);
        $data->status = 0;
        $data->deleted_by = Auth::user()->id;
        $data->deleted_date = Carbon::now();
        $data->save();

        if($data->id !=null){
            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->expense_id = $id;
            $fData->comment = "Expense Deleted";
            $fData->status = 0;
            $fData->save();

            Transaction::where('expense_id', $data->id)->update([
                'updated_by' => Auth::user()->id,
                'updated_date' => Carbon::now(),
                'status' => 0,
            ]);

            $accountsTotal = Accounts::first();
            $totalDebit = ($accountsTotal->debit - $getExpense->amount) ;
            $totalAmount = ($accountsTotal->total + $getExpense->amount) ;

            // dd($totalDebit);

            Accounts::find(1)->update([
                'debit'=> $totalDebit,
                'total'=> $totalAmount,
            ]);

            $notification= array(
                'message' =>'General Expense Deleted Successfully ',
                'alert-type'=>'success'
            );
        }else{
            $notification= array(
                'message' =>'General Expense Not Inserted !!!',
                'alert-type'=>'error'
            );

        }
            return redirect()->route('general-expense')->with($notification);
    }
}
