<?php

namespace App\Http\Controllers\admin\systemConfig;

use App\Models\FootPrint;
use Illuminate\Http\Request;
use App\Models\PaymentMethod;
use App\Models\EmployeeSalary;
use Illuminate\Support\Carbon;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class PaymentMethodController extends Controller
{
    public function index()
    {
        // dd("hello");
        $menu = PaymentMethod::whereIn('status', [1,2])->orderBy('id', 'DESC')->get();
        return view('admin/page/systemConfig/paymentMethod/managePayMethod', get_defined_vars());
    }

    public function store(Request $request)
    {
        // dd($request->all());
        $validator=Validator::make($request->all(), [
            'name' => 'required|unique:payment_methods',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'You can not add same Payment Methods multiple times, Only you can update it.',
                'alert-type'=>'error'
            );
            return back()->with($notification);
        } else {

            $data = new PaymentMethod();
            $data->name = $request->name;
            $data->created_by = Auth::user()->id;
            $data->created_date = Carbon::now();
            $data->status = 1;
            $data->save();

            if($data->id !=null){
                $fData = new FootPrint();
                $fData->operator_id = Auth::user()->id;
                $fData->table_name = "PaymentMethods";
                $fData->table_id = $data->id;
                $fData->comment = "Payment Methods Added";
                $fData->status = 1;
                $fData->save();

                $notification= array(
                    'message' =>'Payment Methods Added successfully',
                    'alert-type'=>'success'
                );

            }else{
                $notification= array(
                    'message' =>'Payment Methods is Not Added !!!',
                    'alert-type'=>'error'
                );

            }

            return back()->with($notification);
        }
    }

    public function update(Request $request)
    {
        $validator=Validator::make($request->all(), [
            'name' => 'required|unique:payment_methods',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'You can not add same Payment Methods multiple times, Only you can update it.',
                'alert-type'=>'error'
            );
            return back()->with($notification);

        } else {

            $data = PaymentMethod::find($request->id);
            $data->name = $request->name;
            $data->updated_by = Auth::user()->id;
            $data->updated_date = Carbon::now();
            $data->status = 2;
            // dd($data);
            $data->save();

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "PaymentMethods";
            $fData->table_id = $request->id;
            $fData->comment = "Payment Methods Updated";
            $fData->status = 2;
            $fData->save();

            $notification= array(
                'message' =>'Payment Methods Updated successfully',
                'alert-type'=>'success'
            );
        }

        return back()->with($notification);
    }

    public function destroy($id)
    {
        $findMenu = EmployeeSalary::where('payment_method_id', $id)->first();

        if ($findMenu != null) {
            $notification= array(
                'message' =>'You can not Delete this Menu !!!',
                'alert-type'=>'error'
            );
            return back()->with($notification);

        } else {

            PaymentMethod::find($id)->update([
                'status'=>0,
                'deleted_by'=>Auth::user()->id,
                'deleted_date'=>Carbon::now()
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "PaymentMethods";
            $fData->table_id = $id;
            $fData->comment = "Payment Methods Deleted";
            $fData->status = 0;
            $fData->save();

            $notification= array(
                'message' =>'Payment Method Deleted Successfully !',
                'alert-type'=>'success'
            );
        }

        return back()->with($notification);
    }
}
