<?php

namespace App\Http\Controllers\admin\systemConfig;

use App\Models\FootPrint;
use App\Models\ServiceType;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class ServiceController extends Controller
{
    public function findService(Request $request)
    {
        $getData=ServiceType::where('id',$request->id)->first();
        //alert($getData);
        echo json_encode($getData);
    }
    public function index()
    {
        $datas = ServiceType::whereIn('status',[1,2,3])->get();
        //dd($datas);
        return view('admin.page.systemConfig.service.serviceType',get_defined_vars());
    }
   
    public function store(Request $request)
    {
        //dd($request->all());
        $data = new ServiceType();
        $data->name =  $request->name;
        $data->status = 1;
        $data->created_by = Auth::user()->id;
        $data->created_date = Carbon::now();
        $data->save();

        if($data->id !=null){
            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->service_type_id = $data->id;
            $fData->comment = "Service Type Inserted";
            $fData->status = 1;
            $fData->save();

            $notification= array(
                'message' =>'Service Inserted Successfully ',
                'alert-type'=>'success'
            );
        }else{
            $notification= array(
                'message' =>'Service Not Inserted !!!',
                'alert-type'=>'error'
            );
        }
            return redirect()->route('view-service-type')->with($notification);
    }
  
    public function update(Request $request)
    {
        //dd($request->all());
        $data = ServiceType::find($request->id);
        $data->name =  $request->name;
        $data->status = 2;
        $data->updated_by = Auth::user()->id;
        $data->updated_date = Carbon::now();
        $data->save();

        if($data->id !=null)
        {
            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->service_type_id = $data->id;
            $fData->comment = "Service Updated";
            $fData->status = 2;
            $fData->save();
    
            $notification= array(
                'message' =>'Service Updated Successfully',
                'alert-type'=>'success'
            );
        }else{
            $notification= array(
                'message' =>'Service Not Inserted !!!',
                'alert-type'=>'error'
            );
        }
            return redirect()->route('view-service-type')->with($notification);
    }
 
    public function destroy($id)
    {
        $data = ServiceType::find($id);
        $data->status = 0;
        $data->deleted_by = Auth::user()->id;
        $data->deleted_date = Carbon::now();
        $data->save();

        if($data->id !=null){

        $fData = new FootPrint();
        $fData->operator_id = Auth::user()->id;
        $fData->service_type_id = $id;
        $fData->comment = "Service Type Deleted";
        $fData->status = 0;
        $fData->save();

        $notification= array(
            'message' =>'Service Type Deleted Successfully',
            'alert-type'=>'success'
        );
        }else{
            $notification= array(
                'message' =>'Service Type Not Inserted !!!',
                'alert-type'=>'error'
            );
        }
            return redirect()->route('view-service-type')->with($notification);
    }
}