<?php

namespace App\Http\Controllers\admin\systemConfig;

use App\Models\FootPrint;
use App\Models\Subscription;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Models\SubscriptionType;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class SubscriptionTypeController extends Controller
{
    public function index()
    {
        // dd("hello");
        $menu = SubscriptionType::whereIn('status', [1,2])->orderBy('id', 'DESC')->get();
        return view('admin/page/systemConfig/subscriptionType/manageSubscriptionType', get_defined_vars());
    }

    public function store(Request $request)
    {
        // dd($request->all());
        $validator = Validator::make($request->all(), [
            'name' => 'required|unique:subscription_types',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'You can not add same Subscription Type multiple times, Only you can update it.',
                'alert-type'=>'error'
            );
            return back()->with($notification);
        } else {

            $data = new SubscriptionType();
            $data->name = $request->name;
            $data->created_by = Auth::user()->id;
            $data->created_date = Carbon::now();
            $data->status = 1;
            $data->save();

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "SubscriptionType";
            $fData->table_id = $data->id;
            $fData->comment = "Subscription Type Added";
            $fData->status = 1;
            $fData->save();

            $notification= array(
                'message' =>'Subscription Type Added successfully',
                'alert-type'=>'success'
            );
            return back()->with($notification);
        }
    }

    public function update(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|unique:payment_methods',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message' =>'You can not add same Subscription Type multiple times, Only you can update it.',
                'alert-type'=>'error'
            );
            return back()->with($notification);

        } else {

            $data = SubscriptionType::find($request->id);
            $data->name = $request->name;
            $data->updated_by = Auth::user()->id;
            $data->updated_date = Carbon::now();
            $data->status = 2;
            // dd($data);
            $data->save();

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "SubscriptionType";
            $fData->table_id = $request->id;
            $fData->comment = "Subscription Type Updated";
            $fData->status = 2;
            $fData->save();

            $notification= array(
                'message' =>'Subscription Type Updated successfully',
                'alert-type'=>'success'
            );
        }

        return back()->with($notification);
    }

    public function destroy($id)
    {
        $findMenu = Subscription::where('subscription_type_id', $id)->first();

        if ($findMenu != null) {
            $notification= array(
                'message' =>'You can not Delete this Menu !!!',
                'alert-type'=>'error'
            );
            return back()->with($notification);

        } else {

            SubscriptionType::find($id)->update([
                'status'=>0,
                'deleted_by'=>Auth::user()->id,
                'deleted_date'=>Carbon::now()
            ]);

            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name = "SubscriptionType";
            $fData->table_id = $id;
            $fData->comment = "Subscription Type Deleted";
            $fData->status = 0;
            $fData->save();

            $notification= array(
                'message' =>'Subscription Type Deleted Successfully !',
                'alert-type'=>'success'
            );
        }

        return back()->with($notification);
    }
}
