<?php

namespace App\Http\Controllers\client;

use App\Models\User;
use App\Models\Order;
use App\Models\SpendMoney;
use Illuminate\Http\Request;
use App\Models\PaymentMethod;
use App\Models\BudgetReceived;
use Illuminate\Support\Facades\DB;
use App\Models\ClientRefundRequest;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class ClientProfileController extends Controller
{
    public function index($id)
    {
        $findUser = User::where('id',$id)->where('role', 3)->first();
        //dd($findUser);
        if($findUser != null ){

            $findClients = User::where('id', $id)->first();
            // dd($id);
            $totalOrder = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->where('order_status', '!=', 8)->count('id');
            $totalPay = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->sum('total_pay');
            $totalDue = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->where('order_status', '!=', 8)->sum('total_due');
            $totalReceived = BudgetReceived::where('client_id', $id)->whereIn('status', [1,2])->sum('received_amount');
            $refundAmount = ClientRefundRequest::where('client_id', $id)->whereIn('status', [1,2])->where('refund_status', 1)->sum('request_amount');
            $currentBalance = $totalReceived - $totalPay;

            // dd($totalReceived);

            $currentOrder = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[1,2,3,4,5,6,7,9])->count('id');
            $currentPay = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[1,2,3,4,5,6,7,9])->sum('total_pay');
            $currentDue = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[1,2,3,4,5,6,7,9])->sum('total_due');

            $completeOrder = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[10, 11])->count('id');
            $completePay = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[10, 11])->sum('total_pay');
            $completeDue = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[10, 11])->sum('total_due');
            // dd($completeDue);
            $datas = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[1,2,3,4,5,6,7,9,10, 11])->orderBy('id','desc')->get();
            $total = DB::select('SELECT COUNT(works_details.id) as total, works_details.order_id as o_id FROM works_details WHERE `status` !=0 GROUP BY works_details.order_id');
            // dd($datas);

            $organization = Order::groupBy('platform')
                            ->select(DB::raw('platform as platform'),DB::raw('count(id) as id'))
                            ->where('order_creator_id', $id)
                            ->whereIn('status', [1,2,3])
                            ->get();

            $geoLocation = Order::groupBy('geo')
                            ->select(DB::raw('geo as geo'),DB::raw('count(id) as id'))
                            ->where('order_creator_id', $id)
                            ->whereIn('status', [1,2,3])
                            ->get();
            // dd($geoLocation);

            $findPaymentMethods = PaymentMethod::whereIn('status', [1,2])->get();

            return view('admin.page.profile.clients.clientsProfile', get_defined_vars());
        }else{
            return view('admin.404');
        }

    }

    public function clientPayment()
    {
        $auth_user = Auth::user();
        $getBudgetReceived = BudgetReceived::whereIn('status', [1,2,4])->where('client_id', $auth_user->id)->get();
        $findPaymentMethods = PaymentMethod::whereIn('status', [1,2])->get();

        return view('admin.page.accounts.client.payment_to_admin', get_defined_vars());
    }

    public function spendMoneyAgainstOrder()
    {
        $spendMoney = SpendMoney::where('client_id', Auth::user()->id)->whereIn('status', [1,2])->get();
        return view('admin.page.accounts.client.spend_money_against_order', get_defined_vars());
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        //
    }

    public function destroy($id)
    {
        //
    }
}
