<?php

namespace App\Http\Controllers\configuration;

use Carbon\Carbon;
use App\Models\Company;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class CompanyController extends Controller
{
    public function create()
    {
        $companyData =  Company::first();
        //dd($companyData);
        return view('admin/configuration/companySetup/company', get_defined_vars());
    }

    public function updateCompanyInfos(request $request)
    {
        $today = Carbon::now();
        Company::truncate();
        $company = new Company;
        $company->Name = $request->name;
        $company->email = $request->email;
        $company->contact = $request->phone;
        $company->address = $request->address;
        $company->website = $request->website;
        $company->tin = $request->tin;
        $company->status = 2;
        $company->updated_by = Auth::user()->id;
        $company->updated_time = $today;

        if ($request->hasFile('logo')) {
            if ($request->file('logo')->isValid()) {
                $image_name = date('mdYHis') . uniqid() . $request->file('logo')->getClientOriginalName();
                $path = base_path() . '/public/companys/';
                $request->file('logo')->move($path, $image_name);
                $company->logo = url('/') . '/companys/' . $image_name;
            }
        }

        if ($request->hasFile('favicon')) {
            if ($request->file('favicon')->isValid()) {
                $image_name = date('mdYHis') . uniqid() . $request->file('favicon')->getClientOriginalName();
                $path = base_path() . '/public/companys/';
                $request->file('favicon')->move($path, $image_name);
                $company->favicon = url('/') . '/companys/' . $image_name;
            }
        }

        if ($request->hasFile('login_logo')) {
            if ($request->file('login_logo')->isValid()) {
                $image_name = date('mdYHis') . uniqid() . $request->file('login_logo')->getClientOriginalName();
                $path = base_path() . '/public/companys/';
                $request->file('login_logo')->move($path, $image_name);
                $company->login_logo = url('/') . '/companys/' . $image_name;
            }
        }

        $company->save();

        $notification= array(
            'message' =>'Company Information Updated !',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
}