<?php

namespace App\Http\Controllers\dashboard;

use App\Models\User;
use App\Models\Order;
use App\Models\Expense;
use App\Models\Accounts;
use App\Models\RiskFund;
use App\Models\SpendMoney;
use App\Models\AssignTable;
use App\Models\Subscription;
use Illuminate\Http\Request;
use App\Models\PaymentMethod;
use App\Models\VendorPayment;
use App\Models\BudgetReceived;
use App\Models\EmployeeSalary;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use App\Models\ClientRefundRequest;
use App\Models\SubscriptionPayment;
use App\Http\Controllers\Controller;
use App\Models\VendorAccount;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        // dd($currentMonth);

        $id = Auth::user()->id;

        // Syetem Admin, Admin & Supervisor Dashboard
        if(Auth::user()->role == 1 || Auth::user()->role == 2 || Auth::user()->role == 5){

            $currentBalance = Accounts::where('id',1)->sum('total');
            $totalEarn = Accounts::where('id',1)->sum('credit');
            $totalCost = Accounts::where('id',1)->sum('debit');
            $totalWithdraw = Accounts::where('id',1)->sum('withdraw');
            $payable = 0.00;
            $receivable = Order::whereIn('status',[1,2,3])->where('order_status', '!=', 8)->sum('total_due');
            $riskFund = RiskFund::where('id', 1)->sum('total');
            // dd($currentBalance);

            $totalOrder = Order::whereIn('status',[1,2,3])->where('order_status', '!=', 8)->count('id');
            $completeOrder = Order::whereIn('status',[1,2,3])->where('order_status',10)->count('id');
            $progressOrder = Order::whereIn('status',[1,2,3])->whereIn('order_status',[2,3,4,5,6,9])->count('id');
            $pendingOrder = Order::whereIn('status',[1,2,3])->where('order_status',1)->count('id');
            $rejectOrder = Order::whereIn('status',[1,2,3])->where('order_status',8)->count('id');
            $holdOrder = Order::whereIn('status',[1,2,3])->where('order_status',7)->count('id');
            $cancelOrder = Order::whereIn('status',[1,2,3])->where('order_status',11)->count('id');

            $datas = Order::whereIn('status',[1,2,3])->whereIn('order_status',[1,2,3,4,5,6,7,9])->orderBy('id','desc')->get();
            $total = DB::select('SELECT COUNT(works_details.id) as total, works_details.order_id as o_id FROM works_details WHERE `status` !=0 GROUP BY works_details.order_id');

            $geoLocation = Order::groupBy('geo')
                        ->select(DB::raw('geo as geo'),DB::raw('count(id) as id'))
                        ->whereIn('status', [1,2,3])
                        ->get();
            // dd($geoLocation);

            $organization = Order::groupBy('platform')
                        ->select(DB::raw('platform as platform'),DB::raw('count(id) as id'))
                        ->whereIn('status', [1,2,3])
                        ->get();

            $orderStatus = Order::groupBy('order_status')
                        ->select(DB::raw('order_status as order_status'),DB::raw('count(id) as id'))
                        ->whereIn('status', [1,2,3])
                        ->get();
            // dd($orderStatus);

            // ********************************************************************
            // Monthly Profit Calculate
            // ********************************************************************
            $startDate = Carbon::now(); //returns current day
            $firstDayOfMonth = $startDate->firstOfMonth()->format('Y-m-d');
            $lastDayOfMonth = $startDate->lastOfMonth()->format('Y-m-d');

            // Monthly Credit
            $totalReceivedAmount = SpendMoney::whereBetween('trans_date',[$firstDayOfMonth, $lastDayOfMonth])
                                            ->whereIn('status', [1,2])
                                            ->sum('total_received_amount');
            // Monthly Debit
            $employeeSalary = EmployeeSalary::whereBetween('trans_date',[$firstDayOfMonth, $lastDayOfMonth])
                                            ->whereIn('status', [1,2])
                                            ->sum('total_salary');

            $vendorPayment = VendorPayment::whereBetween('trans_date',[$firstDayOfMonth, $lastDayOfMonth])
                                            ->whereIn('status', [1,2])
                                            ->sum('pay');

            $subscriptionPayments = SubscriptionPayment::whereBetween('trans_date',[$firstDayOfMonth, $lastDayOfMonth])
                                            ->whereIn('status', [1,2])
                                            ->sum('amount');

            $expenses = Expense::whereBetween('date',[$firstDayOfMonth, $lastDayOfMonth])
                                            ->whereIn('status', [1,2])
                                            ->sum('amount');
            // Monthly Profit

            $monthlyNetProfit = $totalReceivedAmount - ($employeeSalary + $vendorPayment + $subscriptionPayments + $expenses);

            // dd($monthlyNetProfit);

            // ********************************************************************
            // Monthly Profit Calculate
            // ********************************************************************

            $monthlyTotalOrder = Order::whereIn('status',[1,2,3])->whereBetween('created_date',[$firstDayOfMonth, $lastDayOfMonth])->where('order_status', '!=', 8)->count('id');
            
            $monthlyCompleteOrder = Order::whereIn('status',[1,2,3])->whereBetween('updated_at',[$firstDayOfMonth, $lastDayOfMonth])->where('order_status',10)->count('id');
            
            $monthlyProgressOrder = Order::whereIn('status',[1,2,3])->whereBetween('created_date',[$firstDayOfMonth, $lastDayOfMonth])->whereIn('order_status',[2,3,4,5,6,9])->count('id');
            $monthlyPendingOrder = Order::whereIn('status',[1,2,3])->whereBetween('created_date',[$firstDayOfMonth, $lastDayOfMonth])->where('order_status',1)->count('id');
            $monthlyRejectOrder = Order::whereIn('status',[1,2,3])->whereBetween('created_date',[$firstDayOfMonth, $lastDayOfMonth])->where('order_status',8)->count('id');
            $monthlyHoldOrder = Order::whereIn('status',[1,2,3])->whereBetween('created_date',[$firstDayOfMonth, $lastDayOfMonth])->where('order_status',7)->count('id');
            
            $monthlyCancelOrder = Order::whereIn('status',[1,2,3])->whereBetween('updated_at',[$firstDayOfMonth, $lastDayOfMonth])->where('order_status',11)->count('id');

             // ********************************************************************
            // Previous Monthly Profit Calculate
            // ********************************************************************

            $firstDayOfPreviousMonth = date('Y-m-d', strtotime('first day of previous month'));
            $lastDayOfPreviousMonth = date('Y-m-d', strtotime('last day of previous month'));
            // dd($firstDayOfPreviousMonth);

            // Monthly Credit
            $previousMonthtotalReceivedAmount = SpendMoney::whereBetween('trans_date',[$firstDayOfPreviousMonth, $lastDayOfPreviousMonth])
                                            ->whereIn('status', [1,2])
                                            ->sum('total_received_amount');
            // Monthly Debit
            $previousMonthEmployeeSalary = EmployeeSalary::whereBetween('trans_date',[$firstDayOfPreviousMonth, $lastDayOfPreviousMonth])
                                            ->whereIn('status', [1,2])
                                            ->sum('total_salary');

            $previousMonthVendorPayment = VendorPayment::whereBetween('trans_date',[$firstDayOfPreviousMonth, $lastDayOfPreviousMonth])
                                            ->whereIn('status', [1,2])
                                            ->sum('pay');

            $previousMonthSubscriptionPayments = SubscriptionPayment::whereBetween('trans_date',[$firstDayOfPreviousMonth, $lastDayOfPreviousMonth])
                                            ->whereIn('status', [1,2])
                                            ->sum('amount');

            $previousMonthExpenses = Expense::whereBetween('date',[$firstDayOfPreviousMonth, $lastDayOfPreviousMonth])
                                            ->whereIn('status', [1,2])
                                            ->sum('amount');
            // Monthly Profit

            $previousMonthNetProfit = $previousMonthtotalReceivedAmount - ($previousMonthEmployeeSalary + $previousMonthVendorPayment + $previousMonthSubscriptionPayments + $previousMonthExpenses);

            // dd($previousMonthNetProfit);

            // ********************************************************************
            // Previous Monthly Profit Calculate
            // ********************************************************************

            return view('admin.index.index', get_defined_vars());
        }

        // Client Dashboard
        elseif(Auth::user()->role == 3){

            $totalOrder = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->where('order_status', '!=', 8)->count('id');
            $totalPay = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->sum('total_pay');
            $totalDue = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->where('order_status', '!=', 8)->sum('total_due');
            $totalReceived = BudgetReceived::where('client_id', $id)->whereIn('status', [1,2])->sum('received_amount');
            $refundAmount = ClientRefundRequest::where('client_id', $id)->whereIn('status', [1,2])->where('refund_status', 1)->sum('request_amount');
            $currentBalance = $totalReceived - $totalPay;
            // $currentBalance = $totalReceived - $totalPay + $refundAmount;

            $currentOrder = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[1,2,3,4,5,6,7,9])->count('id');
            $currentPay = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[1,2,3,4,5,6,7,9])->sum('total_pay');
            $currentDue = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[1,2,3,4,5,6,7,9])->sum('total_due');

            $completeOrder = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[10, 11])->count('id');
            $completePay = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[10, 11])->sum('total_pay');
            $completeDue = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[10, 11])->sum('total_due');
            // dd($completeDue);
            $datas = Order::where('order_creator_id', $id)->whereIn('status',[1,2,3])->whereIn('order_status',[1,2,3,4,5,6,7,9,])->orderBy('id','desc')->get();
            $total = DB::select('SELECT COUNT(works_details.id) as total, works_details.order_id as o_id FROM works_details WHERE `status` !=0 GROUP BY works_details.order_id');
            // dd($datas);

            $organization = Order::groupBy('platform')
                            ->select(DB::raw('platform as platform'),DB::raw('count(id) as id'))
                            ->where('order_creator_id', $id)
                            ->whereIn('status', [1,2,3])
                            ->get();

            $geoLocation = Order::groupBy('geo')
                            ->select(DB::raw('geo as geo'),DB::raw('count(id) as id'))
                            ->where('order_creator_id', $id)
                            ->whereIn('status', [1,2,3])
                            ->get();
            // dd($geoLocation);

            $findPaymentMethods = PaymentMethod::whereIn('status', [1,2])->get();

            return view('admin.index.clientDashboard.clientDashboard', get_defined_vars());
        }

        // Vendor Dashboard
        elseif(Auth::user()->role == 4){

            $findVendor = User::where('id', Auth::user()->id)->first();

            $totalEarn = AssignTable::where('ven_Emp_id', Auth::user()->id)->whereIn('status',[1,2,3])->sum('total_earn');
            $totalDue = AssignTable::where('ven_Emp_id', Auth::user()->id)->whereIn('status',[1,2,3])->sum('total_due');
            $totalReceived = AssignTable::where('ven_Emp_id', Auth::user()->id)->whereIn('status', [1,2])->sum('total_pay');

            $totalOrder = AssignTable::where('ven_Emp_id', Auth::user()->id)
                        ->whereIn('status', [1,2,3])
                        ->whereIn('work_status', [2,3,4,5,6,7,9,10])
                        ->count('id');


            $completeOrder = AssignTable::where('ven_Emp_id', Auth::user()->id)
                        ->whereIn('status', [1,2,3])
                        ->whereIn('work_status', [10])
                        ->count('id');
            // dd($completeOrder);
            $currentOrder = AssignTable::where('ven_Emp_id', Auth::user()->id)
                        ->whereIn('status', [1,2,3])
                        ->whereIn('work_status', [2, 3, 4, 5, 6, 9])
                        ->count('id');


            $total = DB::select('SELECT COUNT(works_details.id) as total, works_details.order_id as o_id FROM works_details WHERE `status` !=0 GROUP BY works_details.order_id');
            // dd($currentOrder);
            $findAsignOrder = AssignTable::where('ven_Emp_id', Auth::user()->id)
                            ->whereIn('status', [1,2,3])
                            ->whereIn('work_status', [2,3,5,6,9])
                            ->get();
            $vendor_account = VendorAccount::where('balance_holder',Auth::user()->id)->first();

            return view('admin.index.vendorDashboard.vendorDashboard', get_defined_vars());
        }

        // Employee Dashboard
        elseif(Auth::user()->role == 6){

            $findEmployee = User::where('id', Auth::user()->id)->first();

            $totalEarn = AssignTable::where('ven_Emp_id', Auth::user()->id)->whereIn('status',[1,2,3])->sum('total_service_cost');
            $totalDue = AssignTable::where('ven_Emp_id', Auth::user()->id)->whereIn('status',[1,2,3])->sum('total_due');
            $totalReceived = AssignTable::where('ven_Emp_id', Auth::user()->id)->whereIn('status', [1,2])->sum('total_pay');

            $totalOrder = AssignTable::where('ven_Emp_id', Auth::user()->id)
                        ->whereIn('status', [1,2,3])
                        ->whereIn('work_status', [2,3,4,5,6,7,9])
                        ->count('id');

            $completeOrder = AssignTable::where('ven_Emp_id', Auth::user()->id)
                        ->whereIn('status', [1,2,3])
                        ->whereIn('work_status', [4,6])
                        ->count('id');

            $currentOrder = AssignTable::where('ven_Emp_id', Auth::user()->id)
                        ->whereIn('status', [1,2,3])
                        ->whereIn('work_status', [2,3,5,9])
                        ->count('id');


            $total = DB::select('SELECT COUNT(works_details.id) as total, works_details.order_id as o_id FROM works_details WHERE `status` !=0 GROUP BY works_details.order_id');
            // dd($total);
            $findAsignOrder = AssignTable::where('ven_Emp_id', Auth::user()->id)
                            ->whereIn('status', [1,2,3])
                            ->whereIn('work_status', [2,3,5,6,9])
                            ->get();

            return view('admin.index.employeeDashboard.employeeDashboard', get_defined_vars());
        }else{
            return view('admin.404');
        }
    }

    public function vendorReceivedPayment()
    {
        $getVendorSalary = VendorPayment::whereIn('status', [1,2])->where('vendor_id', Auth::user()->id)->get();
        return view('admin.page.accounts.vendor.vendorReceivedPayment', get_defined_vars());
    }

}
