<?php

namespace App\Http\Controllers\websites;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Carbon;
use Illuminate\Http\Request;
use App\Models\ClientLogo;
use App\Models\FootPrint;

class ClientLogoController extends Controller
{
    public function index()
    {
        $clientLogo = ClientLogo::whereIn('status', [1,2,3])->orderBy('id', 'DESC')->get();
        return view('admin.page.manageWebsites.clientLogo.index', get_defined_vars());
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'company_link'  => 'required',
            'image_alt_name'=> 'nullable|string',
            'image'         => 'required|image|mimes:jpg,png,jpeg,gif,svg|max:2048',
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message'   =>'Please Check Error Message !!!',
                'alert-type'=>'error'
            );
            return back()->with($notification);
        } else {

            $data = new ClientLogo;
            $data->company_link = $request->company_link;
            $data->image_alt_name = $request->image_alt_name;
          
            if($request->file('image')){
                $file = $request->file('image');
                    $filename = date('YmdHi').$file->getClientOriginalName();
                    $file->move(public_path('upload/clientLogo'),$filename);
                    $data['image'] = $filename;
            }
            $data->status = 1;
            $data->created_by = Auth::user()->id;
            $data->created_date = Carbon::now();
            $data->save();
            
            $fData = new FootPrint();
            $fData->operator_id = Auth::user()->id;
            $fData->table_name  = 'client_logos';
            $fData->table_id    = $data->id;
            $fData->comment     = "Client Logo Added";
            $fData->status      = 1;
            $fData->save();

            $notification= array(
                'message'   =>'Client Logo Added Successfully',
                'alert-type'=>'success'
            );
            return redirect()->back()->with($notification);
        }
    }

    public function findClientLogo(Request $request)
    {
        $clientLogo = ClientLogo::where('id', $request->clientLogoId)->first();
        echo json_encode($clientLogo);
    }

    public function update(Request $request)
    {
        $validator=Validator::make($request->all(), [
            'company_link'  => 'required',
            'image_alt_name'  => 'nullable|string',
            'image'         => 'nullable|image|mimes:jpg,png,jpeg,gif,svg|max:2048'
        ]);

        if ($validator->fails()) {
            $notification= array(
                'message'   =>'Opps!!! Please check error message',
                'alert-type'=>'error'
            );
            return back()->with($notification);

        } else {

            $data = ClientLogo::find($request->id);
            $data->company_link = $request->company_link;
            $data->image_alt_name = $request->image_alt_name;

            if ($request->file('image')) {

                @unlink(public_path('upload/clientLogo/'.$data->image));

                $file = $request->file('image');
                $filename = date('YmdHi').$file->getClientOriginalName();
                $file->move(public_path('upload/clientLogo'),$filename);
                $data['image'] = $filename;
            }
            $data->updated_by = Auth::user()->id;
            $data->updated_date = Carbon::now();
            $data->status = 2;
            $data->save();

            if($data->id != null)
            {
                $fData = new FootPrint();
                $fData->operator_id = Auth::user()->id;
                $fData->table_name  = 'client_logos';
                $fData->table_id    = $request->id;
                $fData->comment     = "client logo updated";
                $fData->status      = 2;
                $fData->save();

                $notification= array(
                    'message'   =>'Client Logo Updated successfully',
                    'alert-type'=>'success'
                );

            }else{
                $notification= array(
                    'message'   =>'Somethings is wrong !!',
                    'alert-type'=>'error'
                );
            }
            return back()->with($notification);
        }
    }

    public function destroy(ClientLogo $clientLogo)
    {
        $clientLogo->delete();
        $notification = array(
            'message'   =>'Client Logo Deleted Successfully !!',
            'alert-type'=>'success'
        );
        return back()->with($notification);
    }
}
