<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ResetPasswordMail extends Mailable
{
    use Queueable, SerializesModels;

    public $findUserMail, $value;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($findUserMail,$value)
    {
        $this->findUserMail = $findUserMail;
        $this->value = $value;
    }

    public function build()
    {
        return $this->subject('User Password Changes')
                    ->view('emails.resetPassword')->with('findUserMail', 'value', $this->findUserMail, $this->value );
    }
}
