<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AssignTable extends Model
{
    use HasFactory;
    protected $guarded = [];
    /**
     * Get the user that owns the AssignTable
     *
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     */
    public function order()
    {
        return $this->belongsTo(Order::class, 'order_id');
    }

    public function employee()
    {
        return $this->belongsTo(User::class, 'ven_Emp_id');
    }
    public function service()
    {
        return $this->belongsTo(ServiceType::class, 'service_type_id');
    }
}
