<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Config extends Model
{
    use HasFactory;

    protected $fillable = [
        'key',
        'value'
    ];

    public static function getByKey(string $key)
    {
        return Config::where('key', $key)->first();
    }

    public static function getDropdown(string $key)
    {
        $config = self::getByKey($key);

        return $config && $config->value ? json_decode($config->value) : [];
    }
}