<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubscriptionPayment extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function operator(){
        return $this->belongsTo(User::class, 'created_by');
    }

    public function subsType(){
        return $this->belongsTo(SubscriptionType::class, 'subscription_type_id');
    }

    public function subscription(){
        return $this->belongsTo(Subscription::class, 'subscription_id');
    }

    public function payMethod(){
        return $this->belongsTo(PaymentMethod::class, 'payment_method_id');
    }
}
