<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->integer('order_unique_id')->nullable();
            $table->string('apps_link')->nullable();
            $table->string('platform')->nullable();
            $table->string('geo')->nullable();
            $table->integer('service_type_id')->nullable()->comment('service.id = service_type_id');
            $table->date('start_date')->nullable();
            $table->date('target_date')->nullable();
            $table->integer('total_quantity')->nullable();
            $table->integer('perday')->nullable();
            $table->string('key_word')->nullable();
            $table->float('service_cost')->nullable();
            $table->float('total_budget')->nullable();
            $table->integer('order_status')->nullable()->comment('1 = pending, 2 = accept, 3 = work in progress, 4 = finished, 5 = refilling, 6 = refiled, 7 = hold, 8=decline, 9=Active, 10=complete');
            $table->longText('comment')->nullable();
            $table->string('file')->nullable();
            $table->integer('progress')->nullable();
            $table->integer('assigned_quantity')->nullable();
            $table->integer('available_quantity')->nullable();

            $table->integer('status')->nullable()->comment('0=delete, 1= insert, 2= update, 3=active, 4=inactive');
            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->integer('updated_by')->nullable();
            $table->date('updated_date')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->date('deleted_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orders');
    }
};