<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::create('foot_prints', function (Blueprint $table) {
            $table->id();
            $table->integer('operator_id')->nullable();
            $table->integer('status')->nullable()->comment('0=delete, 1= insert, 2= update, 3=active, 4=inactive, 5=Parmanent Delete ,6=restore, 7=deleted Data Restore');
            $table->integer('comment')->nullable();

            $table->string('table_name')->nullable();
            $table->integer('table_id')->nullable();

            $table->integer('user_id')->nullable();
            $table->integer('order-id')->nullable();
            $table->integer('assign_id')->nullable();
            $table->integer('works_details_id')->nullable();
            $table->integer('order_summary_id')->nullable();
            $table->integer('transection_id')->nullable();
            $table->integer('service_type_id')->nullable();
            $table->integer('risk_fund_id')->nullable();
            $table->integer('expense_type_id')->nullable();
            $table->integer('expense_id')->nullable();
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('foot_prints');
    }
};
