<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('assign_tables', function (Blueprint $table) {
            $table->id();
            $table->integer('unique_id')->nullable();
            $table->integer('ven_Emp_id')->nullable();
            $table->integer('order_id')->nullable();
            $table->integer('service_type_id')->nullable();
            $table->integer('total_quantity')->nullable();
            $table->float('vendor_rate', 8,2)->nullable();
            $table->float('total_service_cost', 8,2)->nullable();
            $table->float('total_earn', 8,2)->nullable();
            $table->float('total_pay', 8,2)->nullable();
            $table->float('total_due', 8,2)->nullable();

            $table->date('target_date')->nullable();
            $table->integer('work_status')->nullable()->comment('0 = delete, 1 = pending, 2 = accept, 3 = work in progress, 4 = finished, 5 = refilling, 6 = refiled, 7 = hold/paused, 8 = reject, 9 = update');


            $table->integer('status')->nullable()->comment('0=delete, 1= insert, 2= update, 3=active, 4=inactive');
            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->integer('updated_by')->nullable();
            $table->date('updated_date')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->date('deleted_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('assign_tables');
    }
};
