<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('works_details', function (Blueprint $table) {
            $table->id();
            $table->integer('work_details_u_id')->nullable();
            $table->integer('vandor_id')->nullable();
            $table->integer('order_id')->nullable();
            $table->integer('assign_id')->nullable();
            $table->string('link')->nullable();
            $table->string('reiew_discription')->nullable();
            $table->integer('ratting')->nullable();
            $table->string('title')->nullable();
            $table->integer('service_type_id')->nullable()->comment('service.id = service_type_id');
            $table->date('install_date')->nullable();
            $table->string('keyword')->nullable();
            $table->string('country')->nullable();
            $table->string('country_code')->nullable();
            $table->string('os_version')->nullable();
            $table->string('idfa')->nullable();
            $table->string('ip')->nullable();

            $table->integer('status')->nullable()->comment('0=delete, 1= insert, 2= update, 3=active, 4=inactive');
            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->integer('updated_by')->nullable();
            $table->date('updated_date')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->date('deleted_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('works_details');
    }
};
