<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('withdraws', function (Blueprint $table) {
            $table->id();
            $table->string('from_account')->nullable();
            $table->integer('payment_method_id')->nullable()->comment('payment_methods.id = payment_method_id');
            $table->integer('account_id')->nullable()->comment('accounts.id = account_id');
            $table->float('withdraw_amount',8,2)->nullable()->comment('This amount count as Dollar');
            $table->float('exchange_rate',8,2)->nullable()->comment('This is dollar to BDT(taka) exchange rate');
            $table->float('bdt_amount',8,2)->nullable()->comment('This amount count as BDT(taka)');
            $table->date('trans_date')->nullable();
            $table->longText('note')->nullable();
            $table->integer('status')->nullable()->comment('0 = delete, 1 = insert, 2 = update');

            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->integer('updated_by')->nullable();
            $table->date('updated_date')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->date('deleted_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('withdraws');
    }
};
