<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('spend_money', function (Blueprint $table) {
            $table->id();
            $table->string('transactionID')->nullable();
            $table->integer('order_id')->nullable()->comment('orders.id = order_id');
            $table->integer('client_id')->nullable()->comment('users.id = client_id');
            $table->integer('payment_method_id')->nullable()->comment('payment_methods.id = payment_method_id');

            $table->float('payment_amount',8,2)->nullable();
            $table->float('due',8,2)->nullable();
            $table->float('charge',8,2)->nullable()->comment('This is charge for transfer one bank to another bank');
            $table->float('total_received_amount',8,2)->nullable()->comment('payment_amount - charge = total_received_amount (it store into accounts table)');
            $table->longText('charge_note')->nullable()->comment('This is bank/others charge note');

            $table->date('trans_date')->nullable();
            $table->longText('note')->nullable();
            $table->integer('status')->nullable()->comment('0 = delete, 1 = insert, 2 = update, 3= pending, 4=decline	');

            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->integer('updated_by')->nullable();
            $table->date('updated_date')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->date('deleted_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('spend_money');
    }
};
