<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('client_refund_requests', function (Blueprint $table) {
            $table->id();
            $table->integer('order_id')->nullable()->comment('orders.id = order_id');
            $table->integer('client_id')->nullable()->comment('users.id = client_id');
            $table->integer('service_type_id')->nullable()->comment('service.id = service_type_id');
            $table->integer('payment_method_id')->nullable()->comment('payment_methods.id = payment_method_id');

            $table->integer('quantity')->nullable();
            $table->float('rate',8,2)->nullable();
            $table->float('total_budget',8,2)->nullable();
            $table->integer('total_work')->nullable();
            $table->float('total_cost',8,2)->nullable();

            $table->float('request_amount',8,2)->nullable();
            $table->date('req_date')->nullable();
            $table->longText('note')->nullable();
            $table->integer('refund_status')->nullable()->comment('0 = pending, 1 = complete');
            $table->integer('status')->nullable()->comment('0 = delete, 1 = insert, 2 = update');

            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->integer('updated_by')->nullable();
            $table->date('updated_date')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->date('deleted_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('client_refund_requests');
    }
};
