<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vendor_budget_receiveds', function (Blueprint $table) {
            $table->id();
            $table->integer('payment_method_id')->nullable()->comment('payment_methods.id = payment_method_id');
            $table->double('received_amount')->nullable();
            $table->double('charge')->nullable()->comment('This is charge for transfer one bank to another bank');
            $table->double('total_amount')->nullable();
            $table->longText('charge_note')->nullable()->comment('This is bank/others charge note');

            $table->double('current_balance')->nullable();
            $table->date('trans_date')->nullable();
            $table->string('trnx_id')->nullable();
            $table->longText('note')->nullable();
            $table->integer('status')->nullable()->comment('0 = delete, 1 = insert, 2 = update, 3= pending, 4=decline');
            $table->integer('received_by')->nullable();

            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->integer('updated_by')->nullable();
            $table->date('updated_date')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->date('deleted_date')->nullable();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vendor_budget_receiveds');
    }
};
