<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('order_id');
            $table->unsignedBigInteger('user_id');
            $table->string('order_unique_id');
            $table->string('message');
            $table->integer('status')->nullable()->comment('0=delete, 1= insert, 2= update, 3=active, 4=inactive');
            $table->integer('created_by')->nullable();
            $table->date('created_date')->nullable();
            $table->integer('updated_by')->nullable();
            $table->date('updated_date')->nullable();
            $table->integer('deleted_by')->nullable();
            $table->date('deleted_date')->nullable();
            $table->timestamps();

            $table->foreign('order_id')->references('id')->on('orders')->onDelete('restrict');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('restrict');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notifications');
    }
};
