@extends('admin.masterBlade')

@section('title')
Comapny Info
@endsection
@section('content')
@if(Auth::user()->role == 1)

<!-- Main content -->
<section class="content" style="padding-top: 20px;">
    <div class="col-md-6">
        @if( $companyData != null)
        <div class="card card-navy color-palette">
            <div class="card-header">
                <h5 class="m-0 text-white">Company Informations</h5>
            </div>
            <div class="card-body register-card-body">
                <form action="{{route('updateCompanyInfos')}}" enctype="multipart/form-data" method="post">
                    @csrf
                    <div class="form-group">
                        <div class="row form-group">
                            <label class="col-md-4">Company Name</label>
                            <input type="text" name="name" class="form-control col-md-8"
                                value="{{ $companyData->name }}" placeholder="Company Name">
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Company Email</label>
                            <input type="email" name="email" class="form-control col-md-8"
                                value="{{ $companyData->email }}" placeholder="Email">
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Company Phone</label>
                            <input type="text" name="phone" class="form-control col-md-8"
                                value="{{ $companyData->contact }}" placeholder="Mobile / Phone Number">
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Company Logo</label>
                            <p class="col-md-8">
                                <input type="file" class="form-control" name="logo">
                                @if($companyData->logo)
                                <img src="{{asset($companyData->logo)}}" width="120px" class="img-thumbnail mt-1"
                                    alt="Company Image">
                                @endif
                            </p>
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Company Favicon</label>
                            <p class="col-md-8">
                                <input type="file" class="form-control" name="favicon" value="">
                                @if($companyData->favicon)
                                <img src="{{asset($companyData->favicon)}}" width="75px" class="img-thumbnail mt-1"
                                    alt="Company Favicon">
                                @endif
                            </p>
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Login Logo</label>
                            <p class="col-md-8">
                                <input type="file" class="form-control" name="login_logo">
                                @if($companyData->login_logo)
                                <img src="{{ asset($companyData->login_logo) }}" width="120px"
                                    class="img-thumbnail mt-1" alt="Login Logo">
                                @endif
                            </p>
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Company Licence Number</label>
                            <input type="text" name="tin" value="{{ $companyData->tin }}" class="form-control col-md-8"
                                placeholder="TIN or Licence number">
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Company Website</label>
                            <input type="text" value="{{ $companyData->website }}" name="website"
                                class="form-control col-md-8" placeholder="Company Website">
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Company Address</label>
                            <textarea type="text" rows="5" name="address" class="form-control col-md-8"
                                placeholder="Company Address">{{ $companyData->address }}</textarea>
                        </div>
                        <div class="row" style="justify-content: center;">
                            <div class="col-2">
                                <button type="submit" class="btn btn-primary btn-block">Update</button>
                            </div>
                        </div>
                </form>
            </div>
        </div>
        @else
        <div class="card card-navy color-palette">
            <div class="card-header">
                <h5 class="m-0 text-white">Company Informations</h5>
            </div>
            <div class="card-body register-card-body">
                <form action="{{route('updateCompanyInfos')}}" enctype="multipart/form-data" method="post">
                    @csrf

                    <div class="form-group">
                        <div class="row form-group ">
                            <label class="col-md-4">Company Name</label>
                            <input type="text" name="name" class="form-control col-md-8" placeholder="Company Name">
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Company Email</label>
                            <input type="email" name="email" class="form-control col-md-8" placeholder="Email">
                        </div>
                        <div class="row form-group ">
                            <label class="col-md-4">Company Phone</label>
                            <input type="text" name="phone" class="form-control col-md-8"
                                placeholder="Mobile / Phone Number">
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-4">Company Logo</label>
                            <input type="file" class="form-control col-md-8" name="logo">
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Company Favicon</label>
                            <input type="file" class="form-control col-md-8" name="favicon">
                        </div>
                        <div class="row form-group">
                            <label class="col-md-4">Login Logo</label>
                            <input type="file" class="form-control col-md-8" name="login_logo">
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-4">Company Licence Number</label>
                            <input type="text" name="tin" class="form-control col-md-8"
                                placeholder="TIN or Licence number">

                        </div>
                        <div class="row form-group ">
                            <label class="col-md-4">Company Website</label>
                            <input type="text" name="website" class="form-control col-md-8"
                                placeholder="Company Website">

                        </div>
                        <div class="row form-group ">
                            <label class="col-md-4">Company Address</label>
                            <textarea type="text" rows="5" name="address" class="form-control col-md-8"
                                placeholder="Company Address"></textarea>
                        </div>
                        <div class="row">
                            <div class="col-2" style=" justify-content: center;">
                                <button type="submit" class="btn btn-primary btn-block">Submit</button>
                            </div>
                        </div>
                </form>
            </div>
        </div>
        @endif

    </div>
</section>
@else
@include('admin.404')
@endif

@endsection