@if(Auth::user()->role == 1 || Auth::user()->role == 2)
    <!-- Small boxes (Stat box) -->
    @include('admin.index.adminDashboard.mainContent')
@endif
@if(Auth::user()->role == 1 || Auth::user()->role == 2)
    <!-- Small boxes (Stat box) -->
    @include('admin.index.adminDashboard.monthlyTransaction')
    @include('admin.index.adminDashboard.previousMonthTransaction')
    @include('admin.index.adminDashboard.monthlyOrder')
@endif

<!-- Main row -->
<div class="row">
    @include('admin.index.adminDashboard.charts')
</div>
<!-- /.row (main row) -->

<!-- Main row -->
<div class="row">
    @include('admin.index.adminDashboard.orderList')
</div>
<!-- /.row (main row) -->



{{-- Geo Map Start --}}
<script type="text/javascript">
    google.charts.load('current', {
        'packages': ['geochart'],
    });
    google.charts.setOnLoadCallback(drawRegionsMap);

    function drawRegionsMap() {
        var data = google.visualization.arrayToDataTable([
            ['Country', 'Popularity'],
            @foreach ($geoLocation as $rows)
                [ '{{ $rows->geo }}', {{ $rows->id }} ],
            @endforeach
        ]);

        var options = {};
        options['colors'] = ['#0e9a0e','#dc3912'];
        // options['colors'] = ['#4bb5f3', '#FADC41', '#c44949', '#d74a12', '#0e9a0e', '#55c2ac', '#7c4b91', '#fadc41', '#0d6cca', '#7c4897'];
        var chart = new google.visualization.GeoChart(document.getElementById('regions_div'));

        chart.draw(data, options);
    }
</script>
{{-- Geo Map End --}}

{{-- Donut Chart For Organization Start --}}
<script type="text/javascript">
    google.charts.load("current", {
        packages: ["corechart"]
    });
    google.charts.setOnLoadCallback(drawChart);

    function drawChart() {
        var data = google.visualization.arrayToDataTable([
            ['Platform', 'Total Order'],
            @foreach ($organization as $rows)
                [ '{{ $rows->platform }}', {{ $rows->id }} ],
            @endforeach
        ]);
        var options = {
            pieHole: 0.4,
        };
        var chart = new google.visualization.PieChart(document.getElementById('donutchart'));
        chart.draw(data, options);
    }
</script>
{{-- Donut Chart For Organization End --}}

{{-- Donut Chart For Organization Start --}}
<script type="text/javascript">
    google.charts.load("current", {
        packages: ["corechart"]
    });
    google.charts.setOnLoadCallback(drawChart);

    function drawChart() {
        var data = google.visualization.arrayToDataTable([
            ['Order Status', 'Total Order'],
            @foreach ($orderStatus as $rows)

                @if($rows->order_status == 10)
                    [ 'Complete', {{ $rows->id }} ],
                @elseif($rows->order_status == 9)
                    [ 'Active', {{ $rows->id }} ],
                @elseif($rows->order_status == 8)
                    [ 'Reject', {{ $rows->id }} ],
                @elseif($rows->order_status == 7)
                    [ 'Hold', {{ $rows->id }} ],
                @elseif($rows->order_status == 6)
                    [ 'Refilled', {{ $rows->id }} ],
                @elseif($rows->order_status == 5)
                    [ 'Refilling', {{ $rows->id }} ],
                @elseif($rows->order_status == 4)
                    [ 'Finished', {{ $rows->id }} ],
                @elseif($rows->order_status == 3)
                    [ 'Progress', {{ $rows->id }} ],
                @elseif($rows->order_status == 2)
                    [ 'Accept', {{ $rows->id }} ],
                @elseif($rows->order_status == 1)
                    [ 'Pending', {{ $rows->id }} ],
                @endif
            @endforeach
        ]);
        var options = {
            pieHole: 0.4,
        };
        var chart = new google.visualization.PieChart(document.getElementById('orderStatus'));
        chart.draw(data, options);
    }
</script>
{{-- Donut Chart For Organization End --}}
