<?php
    use Illuminate\Support\Carbon;
    $currentDate = Carbon::now();
    $date = strtotime($currentDate);
    $today = date('Y-m-d', $date);
    // echo $today;  strtotime(date('Y-m-d', $currentDate));
?>
<?php
    $currentURLs = URL::current(); // current url with domain name
    $currentURL = request()->path(); // current url without domain name
    // dd($currentURL);
    $findRole = DB::table('admin_role')->where('url', $currentURL)->where('admin_id', Auth::user()->id)->first();
    // dd($findRole);
?>

@extends('admin.masterBlade')

@section('title')
Budget Received
@endsection

@section('content')

@if($findRole->url == $currentURL )

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Budget Received List
                            <a href="#" title="" data-toggle="modal" data-target="#adds-budget">
                                <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                            </a>
                            <a href="{{url('view-system-config')}}">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Operator</th>
                                    <th>Clients Name</th>
                                    <th>Payment Method</th>
                                    <th>Received Amount</th>
                                    <th>Transaction Date</th>
                                    <th>System Date</th>
                                    <th>Note</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($getBudgetReceived as $key=>$budget)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>
                                        @if($budget->created_by != null)
                                        {{$budget->operator->name }}
                                        @else
                                        N/A
                                        @endif
                                    </td>
                                    <td>
                                        @if($budget->client_id != null)
                                        {{$budget->clients->name }}
                                        @else
                                        N/A
                                        @endif
                                    </td>
                                    <td>
                                        @if($budget->payment_method_id != null)
                                        {{$budget->payMethod->name }}
                                        @else
                                        N/A
                                        @endif
                                    </td>
                                    <td>{{$budget->received_amount }}</td>
                                    <td>{{$budget->trans_date}}</td>
                                    <td>{{$budget->created_at}}</td>
                                    <td>{{$budget->note}}</td>
                                    <td>
                                        @if($budget->status == 3)<span
                                            class="textSize badge badge-warning">Pending</span>
                                        @elseif($budget->status == 4)<span
                                            class="textSize badge badge-warning">Declined</span>
                                        @else<span class="textSize badge badge-info">Accept</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info">Action</button>
                                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                data-toggle="dropdown">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-content" role="menu">
                                                @if(Auth::user()->role == 1 || Auth::user()->role == 2)
                                                <a class="dropdown-item" data-toggle="modal" data-target="#edit-budget"
                                                    onclick="getDataA('<?php echo $budget->id ?>')" href="#"><span
                                                        class="fa fa-edit" style="padding-right:10px;"></span> Edit</a>

                                                @if($budget->status == 3 )
                                                <a class="dropdown-item text-success" id="accept"
                                                    href="{{url('client-budget-received-accept-'.$budget->id)}}"><span
                                                        class="fa fa-check" style="padding-right:10px;"></span>
                                                    Accept</a>
                                                <a class="dropdown-item text-danger" id="declined"
                                                    href="{{url('client-budget-received-declined-'.$budget->id)}}"><span
                                                        class="fas fa-times" style="padding-right:10px;"></span>
                                                    Declined</a>
                                                @endif
                                                
                                                @endif
                                                @if(Auth::user()->role == 1)
                                                <a class="dropdown-item" id="delete"
                                                    href="{{url('destroy-budget-received-'.$budget->id)}}"><span
                                                        class="fa fa-trash" style="padding-right:10px;"></span>
                                                    Delete</a>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>

<!-- /Add budget Modal Start -->
<div class="modal fade" id="adds-budget">
    @include('admin.page.accounts.administration.budgetReceived.addbudget')
</div>
<!-- /Add budget Modal End -->

<!-- /Edit budget Modal Start -->
<div class="modal fade" id="edit-budget">
    @include('admin.page.accounts.administration.budgetReceived.editbudget')
</div>
<!-- /Edit budget Modal End -->

@else
@include('admin.404')
@endif
<script>
    $("#createBudgetReceiveBtn").click(function () {
        $(this).attr("disabled", "disabled");
        $('#createBudgetReceiveForm').submit();
        setTimeout('$("#createBudgetReceiveBtn").removeAttr("disabled")', 1500);
    });
    $("#updateBudgetReceiveBtn").click(function () {
        $(this).attr("disabled", "disabled");
        $('#updateBudgetReceiveForm').submit();
        setTimeout('$("#updateBudgetReceiveBtn").removeAttr("disabled")', 1500);
    });
</script>
@endsection