<?php
    use Illuminate\Support\Carbon;
    $currentDate = Carbon::now();
    $date = strtotime($currentDate);
    $today = date('Y-m-d', $date);
    // echo $today;  strtotime(date('Y-m-d', $currentDate));
?>
<?php
    $currentURLs = URL::current(); // current url with domain name
    $currentURL = request()->path(); // current url without domain name
    // dd($currentURL);
    $findRole = DB::table('admin_role')->where('url', $currentURL)->where('admin_id', Auth::user()->id)->first();
    // dd($findRole);
?>

@extends('admin.masterBlade')

@section('title')
    Client Request Refund List
@endsection

@section('content')

@if(!empty($findRole->url))

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-success table-responsive" style="margin-top:20px;">

                        <div class="card-header text-center">
                            <h5 class="m-0 text-white">Client Refund Request List </h5>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">

                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Order Details</th>
                                        <th>Payment Method</th>
                                        <th>Request Amount</th>
                                        <th>Request Date</th>
                                        <th>Status</th>
                                        <th>Note</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($getRefundData as $key => $getData)
                                    <tr>
                                        <td>{{ ++$key }}</td>
                                        <td>
                                            <span>Order ID: {{ $getData->order->order_unique_id }}</span>,
                                            <span> Service Type: {{ $getData->order->service->name }}</span>,
                                            <span> Quantity: {{ $getData->quantity }}</span>,
                                            <span> Rate: ${{ $getData->rate }}</span>,
                                            <span> Budget: ${{ $getData->total_budget }}</span>,
                                            <span> Total Work: {{ $getData->total_work }}</span>,
                                            <span> Total Cost: ${{ $getData->total_cost }}</span>
                                        </td>
                                        <td>{{ $getData->payMethod->name }}</td>
                                        <td>{{ $getData->request_amount }}</td>
                                        <td>{{ $getData->req_date }}</td>
                                        <td>
                                            @if($getData->refund_status == 0)
                                                <span class="badge badge-danger">Pending</span>
                                            @elseif($getData->refund_status == 1)
                                                <span class="badge badge-success">Complete</span>
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>{{ $getData->note }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-info">Action</button>
                                                <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                    data-toggle="dropdown">
                                                    <span class="sr-only">Toggle Dropdown</span>
                                                </button>
                                                <div class="dropdown-menu dropdown-content" role="menu" >
                                                    @if(Auth::user()->role == 1 || Auth::user()->role == 2)
                                                        @if($getData->refund_status == 0)
                                                            <a class="dropdown-item" href="{{url('pay-clients-refund-request-'.$getData->id)}}"><span
                                                            class="fas fa-hand-holding-usd" style="padding-right:10px;"></span> Pay Now</a>
                                                        @else
                                                        <a class="dropdown-item" href="#"><span
                                                            class="fas fa-exclamation-circle" style="padding-right:10px;"></span> N/A</a>
                                                        @endif
                                                    @endif
                                                </div>
                                            </div>

                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

    @else
        @include('admin.404')
    @endif

@endsection
