<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">Withdraw</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>

        <form id="createWithdrawForm" action="{{url('store-withdraw')}}" enctype="multipart/form-data" method="post" style="padding: 10px">
            @csrf
            <div class="modal-body">

                <div class="form-group">

                    @if(!empty($accountsTotal))
                        <input type="hidden" name="account_id" value="{{ $accountsTotal->id }}">
                    @endif


                    <div class="row form-group">
                        <label class="col-md-5">Transaction ID</label>
                        <input type="text" name="transactionID" class="form-control col-md-7" placeholder="Transaction ID">
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">From Account <span class="text-danger">*</span> </label>
                        <select class="col-md-7 form-control select2bs4" name="payment_method_id" required="" style="width: 58.333%" >
                            <option value="" selected="" disabled="">Select To Account</option>
                            @foreach ($findPaymentMethods as $datas)
                                <option value="{{$datas->id}}">{{$datas->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="row form-group ">
                        <label class="col-md-5">To Account <span class="text-danger">*</span></label>
                        <input type="text" name="to_account" class="form-control col-md-7" required>
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Account Balance ($) </label>
                        @if(!empty($accountsTotal))
                            <input type="number" id="accountsTotal" value="{{ $accountsTotal->total }}" class="form-control col-md-7" readonly>
                        @else
                            <input type="number" id="accountsTotal" value="0.0001" class="form-control col-md-7" readonly>
                        @endif
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Withdraw Amount ($) <span class="text-danger">*</span></label>
                        <input type="number" name="withdraw_amount" id="withdraw_amount" min="0.0001" step="0.0001" class="form-control col-md-7" placeholder="Withdraw Amount ($)" required>
                    </div>
                    <div class="row form-group">
                        <label class="col-md-5">Exchange Rate <span class="text-danger">*</span></label>
                        <input type="number" name="exchange_rate" id="exchange_rate" min="0.0001" step="0.0001" class="form-control col-md-7" required placeholder="Exchange Rate">
                    </div>
                    <div class="row form-group">
                        <label class="col-md-5">Total Amount (BDT) <span class="text-danger">*</span></label>
                        <input type="number" id="bdt_amount" name="bdt_amount" class="form-control col-md-7" readonly required placeholder="Withdraw Amount (Taka)">
                    </div>

                    <div class="row form-group ">
                        <label class="col-md-5">Transaction Date <span class="text-danger">*</span></label>
                        <input type="date" name="trans_date" class="form-control col-md-7" max="{{ $today }}" placeholder="Transaction Date" required>
                    </div>
                    <div class="row form-group ">
                        <label class="col-md-5">Note</label>
                        <textarea type="text" rows="5" name="note" class="form-control col-md-7" placeholder="Note"></textarea>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" id="createWithdrawBtn">Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->

{{-- Add Withdraw Total amount check with current balance --}}
<script type="text/javascript">
    $(document).ready(function () {
        $(document).on('keyup change','#withdraw_amount, #exchange_rate, #bdt_amount ',function(){
            var accountsTotal = parseFloat($('#accountsTotal').val());
            var withdraw_amount = parseFloat($('#withdraw_amount').val());
            var exchange_rate = parseFloat($('#exchange_rate').val());

            console.log(exchange_rate);

            var bdt_amount = parseFloat(withdraw_amount * exchange_rate).toFixed(4);

            if( withdraw_amount > accountsTotal ) {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'You can not Give more than Accounts Total Amount !!!',
                });

                $('#withdraw_amount').val(0.0);
                $('#exchange_rate').val(0.0);
                $('#bdt_amount').val(0.0);
            }else{
                $('#bdt_amount').val(bdt_amount);
            }
        });
    });

</script>
