<?php
    use Illuminate\Support\Carbon;
    $currentDate = Carbon::now();
    $date = strtotime($currentDate);
    $today = date('Y-m-d', $date);
    // echo $today;  strtotime(date('Y-m-d', $currentDate));
?>
<?php
    $currentURLs = URL::current(); // current url with domain name
    $currentURL = request()->path(); // current url without domain name
    // dd($currentURL);
    $findRole = DB::table('admin_role')->where('url', $currentURL)->where('admin_id', Auth::user()->id)->first();
    // dd($findRole);
?>

@extends('admin.masterBlade')

@section('title')
    Withdraw List
@endsection

@section('content')

@if($findRole->url == $currentURL )

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-success table-responsive" style="margin-top:20px;">

                        <div class="card-header text-center">
                            <h5 class="m-0 text-white">Withdraw List
                                <a href="#" title="" data-toggle="modal" data-target="#adds-withdraw">
                                    <i class="fas fa-plus-circle" style="float: right; font-size:28px;"></i>
                                </a>
                                <a href="{{url('view-system-config')}}">
                                    <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                                </a>
                            </h5>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">

                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Transaction ID</th>
                                        <th>Operator</th>
                                        <th>From Account</th>
                                        <th>To Account</th>
                                        <th>Amount (Dollar)</th>
                                        <th>Exchange Rate</th>
                                        <th>Amount (Taka)</th>
                                        <th>Transaction Date</th>
                                        <th>System Date</th>
                                        <th>Note</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($getWithdraw as $key=>$withdraw)
                                    <tr>
                                        <td>{{$key+1}}</td>
                                        <td>
                                            @if($withdraw->transactionID != null)
                                                {{$withdraw->transactionID }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>
                                            @if($withdraw->created_by != null)
                                                {{$withdraw->operator->name }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>
                                            @if($withdraw->payment_method_id != null)
                                                {{$withdraw->payMethod->name }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>
                                            @if($withdraw->from_account != null)
                                                {{$withdraw->from_account }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>{{$withdraw->withdraw_amount }}</td>
                                        <td>{{$withdraw->exchange_rate}}</td>
                                        <td>{{$withdraw->bdt_amount}}</td>
                                        <td>{{$withdraw->trans_date}}</td>
                                        <td>{{$withdraw->created_at}}</td>
                                        <td>{{$withdraw->note}}</td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-info">Action</button>
                                                <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                    data-toggle="dropdown">
                                                    <span class="sr-only">Toggle Dropdown</span>
                                                </button>
                                                <div class="dropdown-menu dropdown-content" role="menu">
                                                    @if(Auth::user()->role == 1 || Auth::user()->role == 2)
                                                        <a class="dropdown-item" data-toggle="modal" data-target="#edit-withdraw"
                                                            onclick="getDataA('<?php echo $withdraw->id ?>')" href="#"><span
                                                            class="fa fa-edit" style="padding-right:10px;"></span> Edit</a>
                                                    @endif
                                                    @if(Auth::user()->role == 1)
                                                        <a class="dropdown-item" id="delete" href="{{url('destroy-withdraw-'.$withdraw->id)}}"><span
                                                            class="fa fa-trash" style="padding-right:10px;"></span> Delete</a>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

    <!-- /Add Withdraw Modal Start -->
    <div class="modal fade" id="adds-withdraw">
        @include('admin.page.accounts.administration.withdraw.addWithdraw')
    </div>
    <!-- /Add Withdraw Modal End -->

    <!-- /Edit Withdraw Modal Start -->
    <div class="modal fade" id="edit-withdraw">
        @include('admin.page.accounts.administration.withdraw.editWithdraw')
    </div>
    <!-- /Edit Withdraw Modal End -->

    @else
        @include('admin.404')
    @endif

    <script>
    $("#createWithdrawBtn").click(function () {
        $(this).attr("disabled", "disabled");
        $('#createWithdrawForm').submit();
        setTimeout('$("#createWithdrawBtn").removeAttr("disabled")', 1500);
    });
    $("#updateWithdrawBtn").click(function () {
        $(this).attr("disabled", "disabled");
        $('#updateWithdrawForm').submit();
        setTimeout('$("#updateWithdrawBtn").removeAttr("disabled")', 1500);
    });
</script>
@endsection
