<?php
    use Illuminate\Support\Carbon;
    $currentDate = Carbon::now();
    $date = strtotime($currentDate);
    $today = date('Y-m-d', $date);
    // echo $today;  strtotime(date('Y-m-d', $currentDate));
?>
<?php
    $currentURLs = URL::current(); // current url with domain name
    $currentURL = request()->path(); // current url without domain name
    // dd($currentURL);
    $findRole = DB::table('admin_role')->where('url', $currentURL)->where('admin_id', Auth::user()->id)->first();
    // dd($findRole);
?>

@extends('admin.masterBlade')

@section('title')
Partial Payment List
@endsection

@section('content')

@if(!empty($findRole->url))

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-12">
                <div class="card card-success">
                    <div class="card-header border-0 ">
                        <h3 class="card-title">Partial Payment List</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <div class="card-body table-responsive" style="padding:10px">
                        <table id="example1" class="table table-striped table-valign-middle">
                            <thead>
                                <tr>
                                    <th>SL</th>
                                    <th>Order ID</th>
                                    <th>App Link</th>
                                    <th>Platfrom</th>
                                    <th>GEO</th>
                                    <th>Service Type</th>
                                    <th>Last Date</th>
                                    <th>Quantity</th>
                                    <th>Service Cost</th>
                                    <th>Budget</th>
                                    <th>Total Pay</th>
                                    <th>Total Due</th>
                                    <th>Progress</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($datas as $key => $data)
                                @php
                                $flag = 1;
                                @endphp
                                <tr>
                                    <td>{{ $key + 1 }}</td>
                                    <td>
                                        <a href="{{ url('check-work-onOrder-' . $data->id) }}"
                                            target="_blank">{{ $data->order_unique_id }}</a>
                                    </td>
                                    <td>
                                        <a href="{{ $data->apps_link }}" target="_blank">Link</a>
                                    </td>
                                    <td>{{ $data->platform }}</td>
                                    <td>{{ $data->geo }}</td>
                                    <td>{{ $data->service->name }}</td>
                                    <td>{{ $data->target_date }}</td>
                                    <td>{{ $data->total_quantity }}</td>
                                    <td>{{ $data->service_cost }}</td>
                                    <td>{{ $data->total_budget }}</td>
                                    <td>
                                        @if($data->total_pay == 0)
                                        <span class="textSize badge badge-danger">Unpaid</span>
                                        @else
                                        {{ $data->total_pay }}
                                        @endif
                                    </td>
                                    <td>
                                        @if($data->total_due == 0)
                                        <span class="textSize badge badge-success">Paid</span>
                                        @else
                                        {{ $data->total_due }}
                                        @endif
                                    </td>
                                    <td>
                                        @foreach ($total as $tData)
                                        @if ($tData->o_id == $data->id)
                                        {{ $tData->total }}/{{ $data->total_quantity }}
                                        @php
                                        $flag = 0;
                                        @endphp
                                        @endif
                                        @endforeach
                                        @if ($flag == 1)
                                        0/{{ $data->total_quantity }}
                                        @endif
                                    </td>
                                    <td>
                                        @if($data->order_status == 1)
                                        <span class="textSize badge badge-warning">Pending</span>
                                        @elseif($data->order_status == 2)
                                        <span class="textSize badge badge-info">Accept</span>
                                        @elseif($data->order_status == 3)
                                        <span class="textSize badge badge-success">Progress</span>
                                        @elseif($data->order_status == 4)
                                        <span class="textSize badge badge-success">Finished</span>
                                        @elseif($data->order_status == 5)
                                        <span class="textSize badge badge-info">Refilling</span>
                                        @elseif($data->order_status == 6)
                                        <span class="textSize badge badge-success">Refilled</span>
                                        @elseif($data->order_status == 7)
                                        <span class="textSize badge badge-danger">Hold</span>
                                        @elseif($data->order_status == 8)
                                        <span class="textSize badge badge-danger">Decline</span>
                                        @elseif($data->order_status == 9)
                                        <span class="textSize badge badge-info">Active</span>
                                        @elseif($data->order_status == 10)
                                        <span class="textSize badge badge-success">Complete</span>
                                        @elseif($data->order_status == 11)
                                        <span class="textSize badge badge-danger">Cancel</span>
                                        @else
                                        N/A
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info">Action</button>
                                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                data-toggle="dropdown">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-content" role="menu">

                                                @if($data->total_due > 0)
                                                <a class="dropdown-item" data-toggle="modal" data-target="#spend-money"
                                                    onclick="getOrderId({{ $data->id }})" href=""><i
                                                        class="fas fa-check" style="padding-right:10px;"></i>Pay</a>
                                                @endif

                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>


<!-- /Add refund request Modal Start -->
<div class="modal fade" id="spend-money">
    @include('admin.page.accounts.client.partialPayment.payAgainestOrder')
</div>
<!-- /Add refund request Modal End -->

@else
@include('admin.404')
@endif

@endsection
