<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">Pay</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>

        <form id="createBudgetReceiveForm" action="{{url('client-payment')}}" enctype="multipart/form-data" method="post" style="padding: 10px">
            @csrf
            <div class="modal-body">

                <div class="form-group">

                    <input type="hidden" name="client_id" value="{{$auth_user->id}}">

                    <div class="row form-group ">
                        <label class="col-md-5">Payment Methods <span class="text-danger">*</span></label>
                        <select class="col-md-7 form-control select2bs4" name="payment_method_id" required="" style="width: 58.333%" >
                            <option value="" selected="" disabled="">Select Payment Methods</option>
                            @foreach ($findPaymentMethods as $datas)
                                <option value="{{$datas->id}}">{{$datas->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Transaction ID</label>
                        <input type="text" name="transactionID" class="form-control col-md-7" placeholder="Transaction ID">
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Pay Amount ($) <span class="text-danger">*</span></label>
                        <input type="number" name="received_amount" id="received_amount" min="0" step="0.01" class="form-control col-md-7" placeholder="Received Amount ($)" required>
                    </div>
                    {{-- <div class="row form-group">
                        <label class="col-md-5">Charge <span class="text-danger">*</span></label>
                        <input type="number" name="charge" id="charge" min="0" step="0.01" class="form-control col-md-7" required placeholder="Charge">
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Total Amount<span class="text-danger">*</span></label>
                        <input type="number" id="total_amount" name="total_amount" class="form-control col-md-7" readonly required placeholder="Received Total Amount ">
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Charge Note</label>
                        <input type="text" name="charge_note" id="charge_note" class="form-control col-md-7" placeholder="Charge Note">
                    </div> --}}

                    <div class="row form-group ">
                        <label class="col-md-5">Transaction Date <span class="text-danger">*</span></label>
                        <input type="date" name="trans_date" class="form-control col-md-7" max="{{ $today }}" placeholder="Transaction Date" required>
                    </div>
                    <div class="row form-group ">
                        <label class="col-md-5">Note</label>
                        <textarea type="text" rows="5" name="note" class="form-control col-md-7" placeholder="Note"></textarea>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" id="createBudgetReceiveBtn">Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->


{{-- Add Withdraw Total amount check with current balance --}}
<script type="text/javascript">
    $(document).ready(function () {
        $(document).on('keyup change','#received_amount, #charge, #total_amount ',function(){
            var received_amount = parseFloat($('#received_amount').val());
            var charge = parseFloat($('#charge').val());

            console.log(charge);

            var total_amount = parseFloat(received_amount - charge).toFixed(2);

            $('#total_amount').val(total_amount);

        });
    });

</script>
