<?php
    use Illuminate\Support\Carbon;
    $currentDate = Carbon::now();
    $date = strtotime($currentDate);
    $today = date('Y-m-d', $date);
    // echo $today;  strtotime(date('Y-m-d', $currentDate));
?>
<?php
    $currentURLs = URL::current(); // current url with domain name
    $currentURL = request()->path(); // current url without domain name
    // dd($currentURL);
    $findRole = DB::table('admin_role')->where('url', $currentURL)->where('admin_id', Auth::user()->id)->first();
    // dd($findRole);
?>

@extends('admin.masterBlade')

@section('title')
    Order Payment Received List
@endsection

@section('content')

@if(!empty($findRole->url))

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-success table-responsive" style="margin-top:20px;">

                        <div class="card-header text-center">
                            <h5 class="m-0 text-white">Order Payment Received List
                                <a href="{{url('view-system-config')}}">
                                    <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                                </a>
                            </h5>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">

                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Operator</th>
                                        <th>Order Id</th>
                                        <th>Service Type</th>
                                        <th>Payment Method</th>
                                        <th>Amount</th>
                                        <th>Charge</th>
                                        <th>Total</th>
                                        <th>Transaction Date</th>
                                        <th>System Date</th>
                                        <th>Note</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $total = 0;
                                    ?>
                                    @foreach($spendMoney as $key=>$spend)
                                    <tr>
                                        <td>{{$key+1}}</td>
                                        <td>
                                            @if($spend->created_by != null)
                                                {{$spend->operator->name }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>
                                            @if($spend->order_id != null)
                                                {{$spend->order->order_unique_id }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>
                                            @if($spend->order_id != null)
                                                {{$spend->order->service->name }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>
                                            @if($spend->payment_method_id != null)
                                                {{$spend->payMethod->name }}
                                            @else
                                                N/A
                                            @endif
                                        </td>
                                        <td>{{$spend->payment_amount }}</td>
                                        <td>{{$spend->charge }}</td>
                                        <td>{{$spend->payment_amount - $spend->charge}}</td>
                                        <td>{{$spend->trans_date}}</td>
                                        <td>{{$spend->created_at}}</td>
                                        <td>{{$spend->note}}</td>
                                    </tr>

                                    <?php $total = $total + $spend->payment_amount ; ?>

                                    @endforeach

                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

    @else
        @include('admin.404')
    @endif

@endsection
