<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <h4 class="modal-title">Update Advance Request</h4>
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>

        <form id="updateBudgetReceiveForm" action="{{url('vendor-update-budget-received')}}" enctype="multipart/form-data" method="post" style="padding: 10px">
            @csrf
            <div class="modal-body">

                <div class="form-group">

                    <input type="hidden" name="id" id="receBId">

                    <div class="row form-group ">
                        <label class="col-md-5">Payment Methods <span class="text-danger">*</span></label>
                        <select class="col-md-7 form-control select" name="payment_method_id" id="gate" required="" style="width: 58.333%"
                        {{ Auth::user()->role == 1 || Auth::user()->role == 2 ? 'disabled' : '' }}>
                            <option id="payMethodName" selected="" value="">Select Payment Methods</option>
                            @foreach ($findPaymentMethods as $datas)
                                <option value="{{$datas->id}}">{{$datas->name}}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="row form-group">
                        <label class="col-md-5">Request Amount ($) <span class="text-danger">*</span></label>
                        <input type="number" name="received_amount" id="received_amounts" min="0" step="0.01" class="form-control col-md-7" placeholder="Received Amount ($)" required>
                    </div>

                    @if(Auth::user()->role == 1 || Auth::user()->role == 2)
                        <div class="row form-group">
                            <label class="col-md-5">Transaction ID</label>
                            <input type="text" name="trnx_id" id="trnx_id" class="form-control col-md-7" placeholder="Transaction ID">
                        </div>

                        <div class="row form-group ">
                            <label class="col-md-5">Transaction Date <span class="text-danger">*</span></label>
                            <input type="date" name="trans_date" id="trans_date" class="form-control col-md-7" max="{{ $today }}" placeholder="Transaction Date" required>
                        </div>
                    @endif

                    <div class="row form-group ">
                        <label class="col-md-5">Note</label>
                        <textarea type="text" rows="5" name="note" id="note" class="form-control col-md-7" placeholder="Note"
                        {{ Auth::user()->role == 1 || Auth::user()->role == 2 ? 'readonly' : '' }}></textarea>
                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary" id="updateBudgetReceiveBtn">Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.modal-content -->
</div>
<!-- /.modal-dialog -->


<script type="text/javascript">

    function getDataA(budgetRId) {
        // console.log(subMenu_id);
        $.ajax({
            url: "vendor-findBudgtRecID", // path to function
            method: "GET",
            data: {
                budgetRId: budgetRId
            },
            dataType: "JSON",

            success: function(res) {

                // console.log(res.payMethodName);
                $("#receBId").val(res.id);
                $("#trnx_id").val(res.trnx_id);
                $("#received_amounts").val(res.received_amount);
                // $("#charges").val(res.charge);
                // $("#total_amounts").val(res.total_amount);
                // $("#charge_notes").val(res.charge_note);
                $("#trans_date").val(res.trans_date);
                $("#note").text(res.note);

                if(res.payMethodName != null)
                {
                    $("#payMethodName").text(res.payMethodName);
                }else{
                    $("#payMethodName").text('N/A');
                }
            },
        });
    }
</script>



{{-- Edit Withdraw Total amount check with current balance --}}
{{-- <script type="text/javascript">
    $(document).ready(function () {
        $(document).on('keyup change','#received_amounts, #charges, #total_amounts ',function(){
            var received_amount = parseFloat($('#received_amounts').val());
            var charge = parseFloat($('#charges').val());

            console.log(charge);

            var total_amount = parseFloat(received_amount - charge).toFixed(2);
            $('#total_amounts').val(total_amount);

        });
    });

</script> --}}
