<?php
    use Illuminate\Support\Carbon;
    $currentDate = Carbon::now();
    $date = strtotime($currentDate);
    $today = date('Y-m-d', $date);
    // echo $today;  strtotime(date('Y-m-d', $currentDate));
?>
<?php
    $currentURLs = URL::current(); // current url with domain name
    $currentURL = request()->path(); // current url without domain name
    // dd($currentURL);
    $findRole = DB::table('admin_role')->where('url', $currentURL)->where('admin_id', Auth::user()->id)->first();
    // dd($findRole);
?>

@extends('admin.masterBlade')

@section('title')
    Received Payment List
@endsection

@section('content')

@if(!empty($findRole->url))

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-success table-responsive" style="margin-top:20px;">

                        <div class="card-header text-center">
                            <h5 class="m-0 text-white">Received Payment List </h5>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="example1" class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>SN</th>
                                        <th>Operator</th>
                                        <th>Vendor Name</th>
                                        <th>Assign ID</th>
                                        <th>Order ID</th>
                                        <th>Service Type</th>
                                        <th>Total Income</th>
                                        <th>Total Received</th>
                                        <th>Total Due</th>
                                        <th>Trans Date</th>
                                        <th>System Date</th>
                                        <th>Note</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($getVendorSalary as $key=>$data)
                                    <tr>
                                        <td>{{$key+1}}</td>
                                        <td>{{$data->operator->name}}</td>
                                        <td>{{$data->vendor->name}}</td>
                                        <td>{{$data->assign->unique_id}}</td>
                                        <td>{{$data->order->order_unique_id}}</td>
                                        <td>{{$data->order->service->name}}</td>
                                        <td>{{$data->amount}}</td>
                                        <td>{{$data->pay}}</td>
                                        <td>{{$data->due}}</td>
                                        <td>{{$data->trans_date}}</td>
                                        <td>{{$data->created_date}}</td>
                                        <td>{{$data->note}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

    @else
        @include('admin.404')
    @endif

@endsection
