
@extends('admin.masterBlade')

@section('title')
Edit Client
@endsection

@section('content')

<div class="col-md-12">
    <!-- Basic Forms -->
    <div class="card card-success" style="padding: 8px; margin-top:8px; ">
        <div class="card-header">
            <h5 class="m-0 text-white text-center">Edit Client Profile
                <a href="javascript:history.back()">
                    <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                </a>
            </h5>
        </div>
        <!-- /.box-header -->

        <div class="box-body" style="padding: 10px; margin-top:20px; ">

            <div class="row">
                <div class="col">
                    <form method="post" action="{{url('update-client-profile-'.$data->id)}}" enctype="multipart/form-data">
                        @csrf

                        <input type="hidden" name="role" value="{{$data->role}}">

                        <div class="row">
                            <div class="col-12">
                                <div class="row">
                                    <!-- 1st Row -->
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <h5>Full Name <span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="name" class="form-control" required="" value="{{$data->name}}">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <h5>Mobile Number <span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <input type="text" name="phone" class="form-control" required="" value="{{$data->phone}}">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <h5>Gender <span class="text-danger">*</span></h5>
                                            <div class="controls">
                                                <select name="gender" id="gender" required="" class="form-control">
                                                    <option value="" selected="" disabled="">Select Gender
                                                    </option>
                                                    <option value="Male" {{($data->gender == "Male" ? "selected" : "")}}>Male</option>
                                                    <option value="Female" {{($data->gender == "Female" ? "selected" : "")}}>Female</option>
                                                    <option value="Other" {{($data->gender == "Other" ? "selected" : "")}}>Other</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->

                                </div> <!-- End 1stRow -->

                                <div class="row">
                                    <!-- 3rd Row -->
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <h5>Address</h5>
                                            <div class="controls">
                                                <textarea type="text" name="address" class="form-control" >{{$data->address}}</textarea>
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <h5>Date of Birth </h5>
                                            <div class="controls">
                                                <input type="date" name="dob" class="form-control" value="{{$data->dob}}">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->
                                </div> <!-- End 3rd Row -->
                                <div class="row">
                                    <!-- 4th Row -->


                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <h5>Profile Image</h5>
                                            <div class="controls">
                                                <input type="file" name="image" class="form-control" id="image" value="{{$data->image}}">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <div class="controls">
                                                <img id="showImage" src="{{(!empty($data->image)) ? url('upload/userImage/'.$data->image):url('upload/NoImage.png')}}"
                                                    style="width: 100px; height: 110px; border: 1px solid #000000;">
                                            </div>
                                        </div>
                                    </div> <!-- End Col md 4 -->

                                </div> <!-- End 4th Row -->

                                <div class="row">
                                    <!-- 6TH Row -->

                                </div> <!-- End 6TH Row -->
                                <div class="row" style="margin-top: 20px">
                                    <!-- 7TH Row -->
                                    <div class="col-md-5">
                                        <div class="text-xs-right">
                                            <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                    </div>
                                </div> <!-- End 7TH Row -->
                            </div>
                        </div>
                    </form>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.box-body -->
    </div>
    <!-- /.box -->
</div>

<script type="text/javascript">
    $(document).ready(function () {
        $('#image').change(function (e) {
            var reader = new FileReader();
            reader.onload = function (e) {
                $('#showImage').attr('src', e.target.result);
            }
            reader.readAsDataURL(e.target.files['0']);
        });
    });

</script>

@endsection
