<?php
    use Illuminate\Support\Carbon;
    $currentDate = Carbon::now();
    $date = strtotime($currentDate);
    $today = date('Y-m-d', $date);
    // echo $today;  strtotime(date('Y-m-d', $currentDate));
?>
@if(Auth::user()->role == 1 || Auth::user()->role == 2 || Auth::user()->role == 5 )
@extends('admin.masterBlade')

@section('title')
Work
@endsection
@section('content')


<section class="content">
    <div class="container-fluid">

        <div class="row" style="margin-top:10px;">

            <div class="col-md-12">
                <div class="card bg-gradient-success">
                    <div class="card-header border-0 ui-sortable-handle" style="cursor: move;">

                        <h3 class="card-title">
                            Order Details
                        </h3>
                        <!-- tools card -->
                        <div class="card-tools">
                            <button type="button" class="btn btn-success btn-sm" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                        <!-- /. tools -->
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body pt-0" style="display: block;">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card pb-2">
                                    <div class="card-header">
                                        <h2 class="card-title text-dark">Order ID : <b>{{$Orders->order_unique_id}}</b>
                                        </h2>
                                        <input type="hidden" name="order_id" id="order_id" value="{{$Orders->id}}">
                                    </div>
                                    <!-- /.card-header -->
                                    <div class="card-body">
                                        <div class="row">
                                            <h2 class="card-title text-dark">App Link: </h2>
                                            <!-- /.col -->
                                            <div class="col-md-5">
                                                <a href="{{$Orders->apps_link}}" target="_blank">Click Me</a>
                                            </div>
                                            <!-- /.col -->
                                            <h2 class="card-title text-dark">File: </h2>
                                            <!-- /.col -->
                                            <div class="col-md-5">
                                                <a href="{{asset('upload/orderFile/'.$Orders->file)}}" download>Download
                                                    Me</a>
                                            </div>
                                            <!-- /.col -->
                                        </div>
                                        <!-- /.row -->
                                    </div>
                                    <!-- /.card-body -->
                                    <div class="card-footer bg-light p-0" style="border-radius: 0.35rem;">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <ul class="nav nav-pills flex-column">
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Order Date
                                                            <span class="float-right ">
                                                                <b>{{$Orders->created_date}}</b></span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Dalivary Date
                                                            <span class="float-right text-danger">
                                                                <b>{{$Orders->target_date}}</b></span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Speed Per day
                                                            <span class="float-right">
                                                                <b>{{$Orders->perday}}</b>
                                                            </span>
                                                        </a>
                                                    </li>

                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            KeyWord
                                                            <span class="float-right">
                                                                <b> {{$Orders->key_word}} </b>
                                                            </span>
                                                        </a>
                                                    </li>

                                                </ul>
                                            </div>
                                            <div class="col-md-6">
                                                <ul class="nav nav-pills flex-column">
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Service Type
                                                            <span class="float-right">
                                                                <b>{{$Orders->service->name}}</b>
                                                            </span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            Platfrom
                                                            <span class="float-right">
                                                                <b>{{$Orders->platform}}</b>
                                                            </span>
                                                        </a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link">
                                                            GEO
                                                            <span class="float-right">
                                                                <b>{{$Orders->geo}}</b>
                                                            </span>
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>

                                        </div>

                                    </div>
                                    <!-- /.footer -->
                                </div>
                                <!-- /.card -->

                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-header">
                                        <h2 class="card-title text-dark">Order Status</h2>
                                    </div>
                                    <!-- /.card-header -->
                                    <div class="card-body">
                                        <div class="row" id="changeStatus">
                                            <h2 class="card-title text-dark">Status :</h2>
                                            <div class="col-md-10">
                                                <div class="form-group">
                                                    @if ($Orders->order_status == 10 || $Orders->order_status == 7 || $Orders->order_status == 11)
                                                    <select id="inputStatus" disabled
                                                        class="form-control custom-select">
                                                        @else
                                                        <select id="inputStatus" onchange="assignStatus(this)"
                                                            class="form-control custom-select">
                                                            @endif
                                                            <option disabled="">Select one</option>
                                                            <option value="1" disabled="disabled"
                                                                {{($Orders->order_status == 1)?'selected':''}}>Pending</option>
                                                            <option value="3"
                                                                {{($Orders->order_status ==3)?'selected':''}}>Work
                                                                in Progress</option>
                                                            <option value="7"
                                                                {{($Orders->order_status ==7)?'selected':''}}>Hold
                                                            </option>
                                                            <option value="5"
                                                                {{($Orders->order_status ==5)?'selected':''}}>
                                                                Refilling</option>
                                                            <option value="6"
                                                                {{($Orders->order_status ==6)?'selected':''}}>
                                                                Refiled</option>
                                                            <option value="4"
                                                                {{($Orders->order_status ==4)?'selected':''}}>
                                                                Finished</option>
                                                            <option value="10" disabled="disabled"
                                                                {{($Orders->order_status ==10)?'selected':''}}>
                                                                Completed</option>
                                                            <option value="2" disabled="disabled"
                                                                {{($Orders->order_status ==2)?'selected':''}}>
                                                                Accept</option>
                                                            <option value="9" disabled="disabled"
                                                                {{($Orders->order_status ==9)?'selected':''}}>
                                                                Active</option>
                                                            <option value="11" disabled="disabled"
                                                                {{($Orders->order_status ==11)?'selected':''}}>
                                                                Canceled</option>
                                                        </select>
                                                </div>
                                            </div>
                                            <!-- /.col -->
                                        </div>
                                        <!-- /.row -->
                                    </div>
                                    <!-- /.card-body -->
                                    @php


                                        $pStatus = ($total*100)/$Orders->total_quantity;
                                        $getTotal = App\Models\WorksDetails::whereIn('status',[1,2,3])->where('order_id',$Orders->id)->where('posting_status',1)->count();
                                        $postingStatus = ($getTotal > 0) ? ($getTotal/$Orders->total_quantity)*100 : 0;
                                    @endphp
                                    <div class="card-footer bg-light pb-1"
                                        style="border-radius: 0.35rem; margin-top: -28px;">
                                        <div class="col-md-12">
                                            <ul class="nav nav-pills flex-column">
                                                <li class="nav-item">
                                                    <a class="nav-link">Progress :
                                                        <td class="project_progress">
                                                            <div class="progress progress-sm">
                                                                <div class="progress-bar bg-green" role="progressbar"
                                                                    aria-valuenow="{{$pStatus}}" aria-valuemin="0"
                                                                    aria-valuemax="100" style="width: {{$pStatus}}%">
                                                                </div>
                                                            </div>
                                                            <small>
                                                                {{number_format($pStatus)}}% Complete
                                                            </small>
                                                        </td>
                                                        <h6 class="float-right">
                                                            {{$total}}/{{$Orders->total_quantity}}
                                                        </h6>
                                                    </a>

                                                    @if($Orders->service_type_id == 1 || $Orders->service_type_id == 2)
                                                    <a class="nav-link"> Posting Status Progress :
                                                        <td class="project_progress">
                                                            <div class="progress progress-sm">
                                                                <div class="progress-bar bg-green" role="progressbar"
                                                                    aria-valuenow="{{$postingStatus}}" aria-valuemin="0"
                                                                    aria-valuemax="100" style="width: {{$postingStatus}}%">
                                                                </div>
                                                            </div>
                                                            <small>
                                                                {{number_format($postingStatus)}}% Complete
                                                            </small>
                                                        </td>
                                                        <h6 class="float-right">
                                                            {{$getTotal}}/{{$Orders->total_quantity}}
                                                        </h6>
                                                    </a>
                                                    @endif

                                                </li>
                                            </ul>

                                        </div>
                                    </div>
                                    <!-- /.footer -->
                                </div>
                                <!-- /.card -->
                            </div>
                            <div class="col-md-3">
                                <div class="card">
                                    <div class="card-header">
                                        <h2 class="card-title text-dark">Reason For Refilling</h2>
                                    </div>
                                    <!-- /.card-header -->
                                    <div class="card-body">
                                        <div class="row">
                                            @if ($Orders->reason != null)
                                            <div class="col-md-12"
                                                style="overflow-y:scroll; height:146px; background:white">
                                                <h2 class="card-title text-dark">{{$Orders->reason}}</h2>
                                            </div>
                                            <!-- /.col -->
                                            @else
                                            <div class="col-md-12" style="height:146px; background:white">

                                            </div>
                                            @endif

                                        </div>
                                        <!-- /.row -->
                                    </div>
                                    <!-- /.card-body -->

                                </div>
                                <!-- /.card -->

                            </div>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
            </div>

            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:10px;">
                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Works Details List
                            <a href="{{route('inProgress-order-v')}}">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>

                    <!-- /.card-header -->
                    <div class="card-body">
                        @if( $Orders->service_type_id !=3)
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Work U_Id</th>
                                    <th width="25%">Review Text</th>
                                    <th>Title</th>
                                    <th>User Name</th>
                                    <th>Rating</th>
                                    <th>Posting Status</th>
                                    <th>Live Date</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($datas as $key=>$data)
                                <tr>
                                    <input type="hidden" id="workId2[]" value="{{$data->id}}">
                                    <td>{{$key+1}}</td>
                                    <td><a href="#">{{$data->work_details_u_id}}</a></td>
                                    <td>{{$data->reiew_discription}}</td>
                                    <td>{{$data->title}}</td>
                                    <td>
                                        @if($data->user_name != null)
                                        <input type="text" class="form-control" id="userNameInput1" {{ $Orders->order_status == 11 ? 'disabled' : '' }}
                                            value="{{$data->user_name}}" readonly="true" ondblclick="this.readOnly='';">
                                        <p hidden>{{$data->user_name}}</p>
                                        @else
                                        <input type="text" id="userNameInput" class="form-control" value="N/A" {{ $Orders->order_status == 11 ? 'disabled' : '' }}
                                            readonly="true" ondblclick="this.readOnly='';">
                                        @endif
                                    </td>
                                    <td>
                                        @for ($i=0;$i<$data->ratting;$i++)
                                            <i class="fa fa-star text-warning"></i>
                                            @endfor
                                            @for ($i=0;$i<5-$data->ratting;$i++)
                                                <i class="far fa-star text-gray"></i>
                                                @endfor
                                                <p hidden>{{$data->ratting}}</p>
                                    </td>
                                    <!-- <td><a href="{{$data->link}}" target="_blank">Click Me</a></td> -->

                                    <!-- Posting Status  -->
                                    <td>
                                        <div id="{{'viewPostingStatus'.$data->id}}"
                                            ondblclick="getOpenPostingStatus({{$data->id}})"
                                            title="Double Click For Update">
                                            @if($data->posting_status == 1)<span class="textSize badge badge-success">
                                                Posted </span>

                                            @elseif($data->posting_status ==2)<span
                                                class="textSize badge badge-danger">Missed</span>

                                            @else<span class="badge">N/A</span>
                                            @endif
                                        </div>
                                        <div id="{{'updatePostingStatus'.$data->id}}" class="col-md-12" hidden>
                                            <div class="form-group workStatus">
                                                @if ($Orders->order_status == 10 || $Orders->order_status == 7 || $Orders->order_status == 11)
                                                <select disabled class="form-control custom-select">
                                                    @else
                                                    <select id="workStatus" onchange="postingStatus(this)"
                                                        class="form-control custom-select">
                                                        @endif
                                                        <option value="" disabled selected>Select One</option>
                                                        <option value="1" {{($data->posting_status ==1)?'selected':''}}>
                                                            <span class="textSize badge badge-success">Posted</span>
                                                        </option>
                                                        <option value="2" {{($data->posting_status ==2)?'selected':''}}>
                                                            <span class="textSize badge badge-info"> Missed </span>
                                                        </option>

                                                        <input type="hidden" id="workId" value="{{$data->id}}">

                                                    </select>
                                            </div>
                                        </div>
                                    </td>
                                    <!-- End Posting Status  -->

                                    <td class="state1">
                                        @if($data->created_date !=null)
                                        <input type="text" class="form-control" id="{{"cuurent-date".$data->id}}"
                                            ondblclick="hide({{$data->id}})" readonly="true" {{ $Orders->order_status == 11 ? 'disabled' : '' }}
                                            value="{{date('m/d/Y', strtotime($data->created_date))}}" max={{$today}}>
                                        <p hidden>{{$data->created_date}}</p>
                                        <input type="hidden" id="{{"input-date".$data->id}}" class="form-control" {{ $Orders->order_status == 11 ? 'disabled' : '' }}
                                            onchange="changeDate(this)" name="date" max={{$today}}>
                                        @else
                                        <input type="date" class="form-control" onchange="changeDate(this)" name="date"
                                            max={{$today}} {{ $Orders->order_status == 11 ? 'disabled' : '' }}>
                                        @endif <input type="hidden" id="workId" value="{{$data->id}}">
                                    </td>
                                    <td class="state">
                                        <div id="{{'viewStatus'.$data->id}}" ondblclick="getOpen({{$data->id}})"
                                            title="Double Click For Update">
                                            @if($data->work_details_status ==1)<span
                                                class="textSize badge badge-info">Alive</span>
                                            @elseif($data->work_details_status ==2)<span
                                                class="textSize badge badge-success">Alive Ok</span>
                                            @elseif($data->work_details_status ==3)<span
                                                class="textSize badge badge-danger">Duplicate</span>
                                            @elseif($data->work_details_status ==4)<span
                                                class="textSize badge badge-warning ">Dropped</span>
                                            @elseif($data->work_details_status ==5)<span
                                                class="textSize badge badge-danger">Wrong Text</span>
                                            @else<span class="badge">N/A</span>
                                            @endif
                                        </div>
                                        <div id="{{'updateStatus'.$data->id}}" class="col-md-12" hidden>
                                            <div class="form-group workStatus">
                                                @if ($Orders->order_status == 10 || $Orders->order_status == 7 || $Orders->order_status == 11 )
                                                <select disabled class="form-control custom-select">
                                                    @else
                                                    <select id="workStatus" onchange="checkbox(this)"
                                                        class="form-control custom-select">
                                                        @endif
                                                        <option value="2"
                                                            {{($data->work_details_status ==2)?'selected':''}}>
                                                            <span class="textSize badge badge-success">Alive Ok</span>
                                                        </option>
                                                        <option value="1"
                                                            {{($data->work_details_status ==1)?'selected':''}}>
                                                            <span class="textSize badge badge-info">Alive</span>
                                                        </option>

                                                        <option value="3"
                                                            {{($data->work_details_status ==3)?'selected':''}}>
                                                            <span class="textSize badge badge-danger">Duplicate</span>
                                                        </option>
                                                        <option value="4"
                                                            {{($data->work_details_status ==4)?'selected':''}}>
                                                            <span class="textSize badge badge-warning">Dropped</span>
                                                        </option>
                                                        <option value="5"
                                                            {{($data->work_details_status ==5)?'selected':''}}>
                                                            <span class="textSize badge badge-danger">Wrong Text</span>
                                                        </option>
                                                        <input type="hidden" id="workId" value="{{$data->id}}">

                                                    </select>
                                            </div>
                                        </div>
                                    </td>
                                    {{-- <input type="hidden" id="workId" value="{{$data->id}}"> --}}
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @else
                        <div class="btn-group " style="float: right; padding-right:10px;">

                            @if ($Orders->order_status == 10 || $Orders->order_status == 7 || $Orders->order_status == 11 )
                            <select disabled class="form-control custom-select">
                                @else
                                <select id="workStatus" onchange="changeAllStatus(this)" class="form-control custom-select">
                                    @endif
                                    <option value="" disabled selected>
                                        <span class="textSize badge badge-success">Update Selected</span>
                                    </option>
                                    <option value="2">
                                        <span class="textSize badge badge-success">Alive Ok</span>
                                    </option>
                                    <option value="1">
                                        <span class="textSize badge badge-info">Alive</span>
                                    </option>

                                    <option value="3">
                                        <span class="textSize badge badge-danger">Duplicate</span>
                                    </option>
                                    <option value="4">
                                        <span class="textSize badge badge-warning">Dropped</span>
                                    </option>
                                    <option value="5">
                                        <span class="textSize badge badge-danger">Wrong Text</span>
                                    </option>

                                </select>
                            </div>

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th class="text-center" width="8%"><input class="form-check-input" id="check_all" type="checkbox">SN</th>
                                    <th>Work U_Id</th>
                                    <th>Install Date</th>
                                    <th>Keyword</th>
                                    <th>Country</th>
                                    <th>Country Code</th>
                                    <th>osVersion</th>
                                    <th>IDFA</th>
                                    <th>IP</th>
                                    <th>Status</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($datas as $key=>$data)
                                <tr>
                                    <td class="text-center">
                                        <input class="form-check-input td_checkbox" id="{{'td_checkbox_'.$data->id}}" name="check_id[]" type="checkbox" data-id={{$data->id}}>
                                        {{$key+1}}
                                    </td>
                                    <td><a href="#" target="_blank">{{$data->work_details_u_id}}</a></td>
                                    <td>{{date('m/d/Y', strtotime($data->install_date))}}</td>
                                    <td>{{$data->keyword}}</td>
                                    <td>{{$data->country}}</td>
                                    <td>{{$data->country_code}}</td>
                                    <td>{{$data->os_version}}</td>
                                    <td><input type="hidden" id="{{'idfa_'.$data->id}}" value="{{$data->idfa}}">{{$data->idfa}}</td>
                                    <td>{{$data->ip}}</td>
                                    <td class="state">
                                        <div id="{{'viewStatus'.$data->id}}" ondblclick="getOpen({{$data->id}})"
                                            title="Double Click For Update">
                                            @if($data->work_details_status ==1)<span
                                                class="textSize badge badge-info">Alive</span>
                                            @elseif($data->work_details_status ==2)<span
                                                class="textSize badge badge-success">Alive Ok</span>
                                            @elseif($data->work_details_status ==3)<span
                                                class="textSize badge badge-danger">Duplicate</span>
                                            @elseif($data->work_details_status ==4)<span
                                                class="textSize badge badge-warning ">Dropped</span>
                                            @elseif($data->work_details_status ==5)<span
                                                class="textSize badge badge-danger">Wrong Text</span>
                                            @else<span class="badge">N/A</span>
                                            @endif
                                        </div>
                                        <div id="{{'updateStatus'.$data->id}}" class="col-md-12" hidden>
                                            <div class="form-group workStatus">
                                                @if ($Orders->order_status == 10 || $Orders->order_status == 7 || $Orders->order_status == 11 )
                                                <select disabled class="form-control custom-select">
                                                    @else
                                                    <select id="workStatus" onchange="checkbox(this)"
                                                        class="form-control custom-select">
                                                        @endif
                                                        <option value="2"
                                                            {{($data->work_details_status ==2)?'selected':''}}>
                                                            <span class="textSize badge badge-success">Alive Ok</span>
                                                        </option>
                                                        <option value="1"
                                                            {{($data->work_details_status ==1)?'selected':''}}>
                                                            <span class="textSize badge badge-info">Alive</span>
                                                        </option>

                                                        <option value="3"
                                                            {{($data->work_details_status ==3)?'selected':''}}>
                                                            <span class="textSize badge badge-danger">Duplicate</span>
                                                        </option>
                                                        <option value="4"
                                                            {{($data->work_details_status ==4)?'selected':''}}>
                                                            <span class="textSize badge badge-warning">Dropped</span>
                                                        </option>
                                                        <option value="5"
                                                            {{($data->work_details_status ==5)?'selected':''}}>
                                                            <span class="textSize badge badge-danger">Wrong Text</span>
                                                        </option>
                                                        <input type="hidden" id="workId" value="{{$data->id}}">

                                                    </select>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                        @endif
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>

</section>

<script>
    function hide(r) {
        document.getElementById("cuurent-date" + r).type = "hidden";
        document.getElementById("input-date" + r).type = "date";
    }
</script>

<script>
    function changeDate(_this) {

        var p_state = $(_this).closest('tr').find('#state1').text(); // get the text
        var p_status = _this.value; // get the selected value
        var id = $(_this).closest('td').find('#workId').val();

        if (id != '') {
            $.ajax({
                url: "updateWorkDetailsDate",
                method: "GET",
                data: {
                    id: id,
                    p_status: p_status,
                },
                dataType: "JSON",
                success: function (data) {
                    // window.location.reload();
                    toastr.success(" Date Updated ");
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }
</script>

<!-- Update Work status -->
<script type="text/javascript">

    let allCheckVal = [];
    // Single check
    $('.td_checkbox').change(function(){
        getCheckRecords();
    });

    // All Check
    $("#check_all").change(function(){
        if($(this).prop('checked'))
        {
            $('.td_checkbox').not(this).prop('checked',true);
        }else{
            $('.td_checkbox').not(this).prop('checked',false);
        }
        getCheckRecords();
    });

    //Get Check Records
    function getCheckRecords()
    {
        allCheckVal = [];
        $('.td_checkbox:checked').each(function() {
            allCheckVal.push($(this).attr('data-id'));
        });
    }

    function value(r) {
        var id = r;
    };

    function changeAllStatus(_this)
    {
        var p_state = $(_this).closest('tr').find('#state').text(); // get the text
        var p_status = _this.value; // get the selected value

        if(allCheckVal.length > 0)
        {
            $.each( allCheckVal, function( key, id ) {
                var idfa = $('#idfa_'+id).val();

                if(idfa == '' && p_status == 2){
                    toastr.error("This Work Don't any IDFA number");
                }else{
                    updateWorkStatus(id, p_status);
                }
            });
        }else{
            Swal.fire({
                    title: 'Are you sure Select Any thing?',
                    text: "You don't Select Any Work !!",
                    icon: 'warning',
                    // showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'No, Close it!'
                })
        }
    }

    //update in sigle row
    function checkbox(_this) {
        var p_state = $(_this).closest('tr').find('#state').text(); // get the text
        var p_status = _this.value; // get the selected value
        var id = $(_this).closest('td').find('#workId').val();
        updateWorkStatus(id, p_status);
    }

    //Update Request
    function updateWorkStatus(id, p_status)
    {
        if (id != '') {
            $.ajax({
                url: "updateWorkDetailsStatus",
                method: "GET",
                data: {
                    id: id,
                    p_status: p_status,
                },
                dataType: "JSON",
                success: function (data) {

                    toastr.success("Work status Update");

                    setTimeout(function() {
                        window.location.reload();
                    }, 2000);
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }
</script>


<script>
    function assignStatus(r) {

        var value = r.value;
        var id = $('#order_id').val();

        if (id != '') {
            $.ajax({
                url: "updateOrderStatus",
                method: "GET",
                data: {
                    id: id,
                    value: value,
                },
                dataType: "JSON",
                success: function (data) {

                    var type = data.order_status;

                    switch (type) {
                        case 3:
                            toastr.info(" Work In Progress ");
                            break;
                        case 4:
                            toastr.success(" Order Finished ");
                            break;
                        case 5:
                            toastr.warning(" Order Refilling ");
                            break;
                        case 6:
                            toastr.success(" Order Refilled ");
                            break;
                        case 7:
                            toastr.error(" Hold ");
                            break;
                    }

                    setTimeout(function() {
                        window.location.reload();
                    }, 1000);
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }
</script>
<script>
    $('body').on('keypress', '#userNameInput', function (e) {
        if (e.which == 13) {
            //alert('enter');

            var parent = $(this).closest('tr');
            var id = parent.find('input:eq(0)').val();
            var value = parent.find('#userNameInput').val();

            //   var id =  $('#userNameInput').closest('td').find('#workId2').val();
            //   var value =  $('#userNameInput').val();

            if (id != '') {
                $.ajax({
                    url: "updateUserName",
                    method: "GET",
                    data: {
                        id: id,
                        value: value,
                    },
                    dataType: "JSON",
                    success: function (data) {
                        // window.location.reload();
                        toastr.success("User Name Update");
                    }
                })
            } else {
                alert("Something is wrong ..!!");
            }
        }
    });

    $('body').on('keypress', '#userNameInput1', function (e) {
        if (e.which == 13) {
            //alert('enter');

            var parent = $(this).closest('tr');
            var id = parent.find('input:eq(0)').val();
            var value = parent.find('#userNameInput1').val();

            //   var id =  $('#userNameInput').closest('td').find('#workId2').val();
            //   var value =  $('#userNameInput').val();

            if (id != '') {
                $.ajax({
                    url: "updateUserName",
                    method: "GET",
                    data: {
                        id: id,
                        value: value,
                    },
                    dataType: "JSON",
                    success: function (data) {
                        // window.location.reload();
                        toastr.success("User Name Update");

                    }
                })
            } else {
                alert("Something is wrong ..!!");
            }
        }
    });
</script>

<script>
    function getOpen(r) {
        $('#updateStatus' + r).removeAttr('hidden');
        $('#viewStatus' + r).attr('hidden', '');
    }
</script>

<!-- posting status Start-->
<script>
    function getOpenPostingStatus(r) {
        $('#updatePostingStatus' + r).removeAttr('hidden');
        $('#viewPostingStatus' + r).attr('hidden', '');
    }

    function postingStatus(_this) {
        var p_state = $(_this).closest('tr').find('#state').text(); // get the text
        var posting_status = _this.value; // get the selected value
        var id = $(_this).closest('td').find('#workId').val();

        if (id != '') {
            $.ajax({
                url: "updatePostingStatus",
                method: "GET",
                data: {
                    id: id,
                    posting_status: posting_status,
                },
                dataType: "JSON",
                success: function (data) {
                    toastr.success(" Status Update ");

                    // setTimeout( function(){
                    //     window.location.reload(true);
                    // }  , 1000 );


                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }

</script>
@endsection

@else
@include('admin.404')
@endif
