@if(Auth::user()->role == 1 || Auth::user()->role == 2 || Auth::user()->role == 5 )
@extends('admin.masterBlade')

@section('title')
Decline Order List
@endsection

@section('content')

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Decline Order List
                            <a href="javascript:history.back()">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>

                    <!-- /.card-header -->
                    <div class="card-body">
                        <!-----------------------Active/Inactive Button--------------------->

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Unique Id</th>
                                    <th>Client Name</th>
                                    <th>App Link</th>
                                    <th>Platfrom</th>
                                    <th>GEO</th>
                                    <th>Service Type</th>
                                    <th>Last Date</th>
                                    <th>Quantity</th>
                                    <th>Service Cost</th>
                                    <th>Budget</th>
                                    <th>Perday Work</th>
                                    <th>KeyWord</th>
                                    <th>Comment</th>
                                    <th>File</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($datas as $key=>$data)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td>{{$data->order_unique_id}}</td>
                                    <td>{{$data->client->name}}</td>
                                    <td><a href="{{$data->apps_link }}" target="_blank" >Link</a></td>
                                    <td>{{$data->platform}}</td>
                                    <td>{{$data->geo}}</td>
                                    <td>{{$data->service->name}}</td>
                                    <td>{{$data->target_date}}</td>
                                    <td>{{$data->total_quantity}}</td>
                                    <td>{{$data->service_cost}}</td>
                                    <td>{{$data->total_budget}}</td>
                                    <td>{{$data->perday}}</td>
                                    <td>{{$data->key_word}}</td>

                                    <td>
                                        <input id="exp{{$key+1}}" class="exp"  type="checkbox">
                                        <div class="text">
                                            <label class="btns" for="exp{{$key+1}}"></label>
                                            {{$data->comment}}
                                        </div>
                                    </td>

                                    <td>@if($data->file != null)<a href="{{asset('upload/orderFile/'.$data->file)}}" download>{{$data->file}}</a>@else No File @endif</td>
                                    <td>

                                        @if($data->order_status ==1)<span class="textSize badge badge-warning">Pending</span>
                                        @elseif($data->order_status ==2)<span class="textSize badge badge-info">Accept</span>
                                        @elseif($data->order_status ==3)<span class="textSize badge badge-success">In Process</span>
                                        @elseif($data->order_status ==4)<span class="textSize badge badge-warning ">Finished</span>
                                        @elseif($data->order_status ==5)<span class="textSize badge badge-danger">Refilling</span>
                                        @elseif($data->order_status ==6)<span class="textSize badge badge-secondary">Refiled</span>
                                        @elseif($data->order_status ==7)<span class="textSize badge badge-primary">Hold</span>
                                        @elseif($data->order_status ==8)<span class="textSize badge badge-warning">Decline</span>
                                        @elseif($data->order_status ==9)<span class="textSize badge badge-primary">Active</span>
                                        @elseif($data->order_status ==10)<span class="textSize badge badge-success">Complete</span>
                                        @elseif($data->order_status ==11)<span class="textSize badge badge-danger">Canceled</span>
                                        @else<span class="badge">N/A</span>
                                        @endif

                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info">Action</button>
                                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                data-toggle="dropdown">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-content" role="menu">
                                                @if(Auth::user()->role == 1 || Auth::user()->role == 2)
                                                <a class="dropdown-item" href="{{url('accept-pending-order-'.$data->id)}}"><i
                                                    class="fas fa-check" style="padding-right:10px;"></i> Accept</a>
                                                <a class="dropdown-item" href="{{url('dicline-pending-order-'.$data->id)}}"><i class="fas fa-times-circle"
                                                    style="padding-right:10px; "></i> Dicline</a>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>

@endsection


@else
    @include('admin.404')
@endif
