@if(Auth::user()->role == 1 || Auth::user()->role == 2 || Auth::user()->role == 5 )
@extends('admin.masterBlade')

@section('title')
Hold Assign Order
@endsection

@section('content')
@php
$var1 = 0;
@endphp
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Hold Assign Order List
                            <a href="javascript:history.back()">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>

                    <!-- /.card-header -->
                    <div class="card-body">
                        <!-----------------------Active/Inactive Button--------------------->

                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Assign Uni_Id</th>
                                    <th>Order Uni_Id</th>
                                    <th>Assign To</th>
                                    <th>Total Quantity</th>
                                    <th>Rate</th>
                                    <th>Budget</th>
                                    <th>Service</th>
                                    <th>Targeted Date</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($datas as $key=>$data)
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td><a href="{{url('check-work-details-'.$data->id)}}"
                                            target="_blank">{{$data->unique_id}}</a></td>
                                    <td><a href="#" target="_blank">{{$data->order->order_unique_id}}</a></td>
                                    <td><a href="#" target="_blank">{{$data->employee->name}}</a></td>
                                    <td>{{$data->total_quantity}}</td>
                                    <td>{{number_format($data->vendor_rate,2)}}</td>
                                    <td>{{number_format($data->total_service_cost,2)}}</td>
                                    <td>{{$data->service->name}}</td>
                                    <td>{{$data->target_date}}</td>
                                    <td>
                                        @if($data->work_status ==1)<span
                                            class="textSize badge badge-warning">Pending</span>
                                        @elseif($data->work_status ==2)<span
                                            class="textSize badge badge-info">Accept</span>
                                        @elseif($data->work_status ==3)<span class="textSize badge badge-success">In
                                            Process</span>
                                        @elseif($data->work_status ==4)<span
                                            class="textSize badge badge-warning ">Finished From Vendor</span>
                                        @elseif($data->work_status ==5)<span
                                            class="textSize badge badge-danger">Refilling</span>
                                        @elseif($data->work_status ==6)<span
                                            class="textSize badge badge-secondary">Refiled</span>
                                        @elseif($data->work_status ==7)<span
                                            class="textSize badge badge-warning">Hold</span>
                                        @elseif($data->work_status ==8)<span
                                            class="textSize badge badge-danger">Reject</span>
                                        @elseif($data->work_status ==9)<span
                                            class="textSize badge badge-primary">Update</span>
                                        @elseif($data->work_status ==10)<span
                                            class="textSize badge badge-secondary">Completed</span>
                                        @elseif($data->work_status ==11)<span
                                            class="textSize badge badge-danger">Canceled</span>
                                        @else<span class="badge">N/A</span>
                                        @endif

                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info">Action</button>
                                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                data-toggle="dropdown">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-content" role="menu">
                                                @if(Auth::user()->role == 1 || Auth::user()->role == 2)
                                                @if($data->work_status !=4)
                                                @if($data->work_status !=8 && $data->work_status !=10)
                                                <a class="dropdown-item" data-toggle="modal"
                                                    data-target="#modal-default"
                                                    onclick="editAssignOrder({{$data->id}})"><i class="fas fa-check"
                                                        style="padding-right:10px;"></i> Edit</a>
                                                @if ($data->work_status == 7)
                                                <a class="dropdown-item"
                                                    href="{{url('resume-assign-order-'.$data->id)}}"><i
                                                        class="fas fa-times-circle"
                                                        style="padding-right:10px; "></i>Resume</a>
                                                @else
                                                <a class="dropdown-item"
                                                    href="{{url('hold-assign-order-'.$data->id)}}"><i
                                                        class="fas fa-times-circle" style="padding-right:10px; "></i>
                                                    Hold</a>
                                                @endif
                                                @else
                                                <a class="dropdown-item">No Action</a>
                                                @endif
                                                @else
                                                <a class="dropdown-item" data-toggle="modal" data-target="#modal-check"
                                                    onclick="AssignForCheck({{$data->id}})"><i class="fas fa-check"
                                                        style="padding-right:10px;"></i>Assign For Check</a>
                                                @endif
                                                @endif

                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>


<div class="modal fade" id="modal-default">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Edit Assign Order</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('edit-assign-order')}}" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="order_id" id="order_id">
                            <input type="hidden" name="assign_id" id="id">
                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-10">
                                            <div class="form-group">
                                                <h5>Select Vendor/Employee<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="ven_Emp_id" id="ven_Emp_id" required=""
                                                        class="form-control ven_Emp_id">
                                                        <option value="" id="pname" selected="" disabled="">Select
                                                            Vendor/Employee</option>
                                                        @foreach ($workers as $item)
                                                        <option value="{{$item->id}}">{{$item->name}} ~~
                                                            {{$item->email}}</option>
                                                        @endforeach

                                                    </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 6 -->
                                    </div> <!-- End 1stRow -->

                                    <div class="row" id="calculation">
                                        <!-- 2nd Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Quantity <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" name="total_quantity" id="total_quantity"
                                                        class="form-control" required="">
                                                    <span id='message'></span>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Service Cost(/Work) <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" step="0.1" name="service_cost"
                                                        id="service_cost" class="form-control" required="">
                                                    <span id='message2'></span>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 2nd Row -->

                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Budget <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" name="total_budget" id="total_budget"
                                                        class="form-control" readonly required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Dalivary Date</h5>
                                                <div class="controls">
                                                    <input type="date" name="target_date" id="target_date" required
                                                        class="form-control">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 3rd Row -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5"
                                                    value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->


<div class="modal fade" id="modal-check">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Assign For Check</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('assign-order-check')}}" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="assign_id" id="assign_id">
                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-10">
                                            <div class="form-group">
                                                <h5>Select Employee<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="ven_Emp_id" required=""
                                                        class="form-control">
                                                        <option value="" selected="" disabled="">Select
                                                            Employee</option>
                                                        @foreach ($employees as $item)
                                                        <option value="{{$item->id}}">{{$item->name}} ~~
                                                            {{$item->email}}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 6 -->
                                    </div> <!-- End 1stRow -->
                                </div>

                            </div>
                            <div class="row" style="margin-top: 20px">
                                <!-- 7TH Row -->
                                <div class="col-md-5">
                                    <div class="text-xs-right">
                                        <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Assign">
                                    </div>
                                </div>
                            </div> <!-- End 7TH Row -->
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<script type="text/javascript">
    $("#calculation").on("keyup click", function () {
        var qty = parseFloat($('#total_quantity').val());
        var price = parseFloat($('#service_cost').val());
        var unit_total = parseFloat(qty * price);
        $("#total_budget").val(unit_total.toFixed(2));
    });

</script>

<script>
    function editAssignOrder(r) {
        console.log(r);
        $("#id").val(r);
        var id = r;

        if (id != '') {
            $.ajax({
                url: "editAssignOrders",
                method: "GET",
                data: {
                    id: id,
                },
                dataType: "JSON",
                success: function (data) {
                    console.log(data);

                    var total = parseInt(data.available) + parseInt(data.total_quantity);
                    $("#ven_Emp_id").val(data.ven_Emp_id);
                    $("#total_quantity").val(data.total_quantity);
                    $("#service_cost").val(data.vendor_rate);
                    $("#total_budget").val(data.total_service_cost);
                    $("#target_date").val(data.target_date);
                    $("#order_id").val(data.order_id);

                    $("#total_quantity").attr({
                        "max": total,
                        "min": 1
                    });
                    $('#message').html('Available Work Here - ' + data.available + '+' + data
                        .total_quantity + '=' + total).css('color', 'red');
                    $('#message2').html('Client Rate - ' + data.serviceCost).css('color', 'red');
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }

</script>

<script>
    function AssignForCheck(r) {
        console.log(r);
        $("#assign_id").val(r);
    }

</script>
@endsection


@else
@include('admin.404')
@endif
