@if(Auth::user()->role == 1 || Auth::user()->role == 2 || Auth::user()->role == 5 )
@extends('admin.masterBlade')

@section('title')
Hold Order List
@endsection
@section('content')


<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card card-success table-responsive" style="margin-top:20px;">

                    <div class="card-header text-center">
                        <h5 class="m-0 text-white">Hold Order List
                            <a href="javascript:history.back()">
                                <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                            </a>
                        </h5>
                    </div>

                    <!-- /.card-header -->
                    <div class="card-body">
                        <!-----------------------Active/Inactive Button--------------------->
                        <table id="example1" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>SN</th>
                                    <th>Clients</th>
                                    <th>Unique Id</th>
                                    <th>App Link</th>
                                    <th>Platfrom</th>
                                    <th>GEO</th>
                                    <th>Service Type</th>
                                    <th>Last Date</th>
                                    <th>Quantity</th>
                                    <th>Available Work</th>
                                    <th>Service Cost</th>
                                    <th>Budget</th>
                                    <th>Perday Work</th>
                                    <th>KeyWord</th>
                                    <th>Progress</th>
                                    <th>Status</th>
                                    <th>Comment</th>
                                    <th>File</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($datas as $key=>$data)
                                  @php
                                      $flag = 1;
                                  @endphp
                                <tr>
                                    <td>{{$key+1}}</td>
                                    <td><a href="{{url('client-profile-'.$data->id)}}" target="_blank" >{{ $data->client->name }}</a></td>
                                    <td><a href="{{url('check-work-onOrder-'.$data->id)}}" target="_blank" >{{$data->order_unique_id}}</a></td>
                                    <td><a href="{{$data->apps_link }}" target="_blank" >Link</a></td>
                                    <td>{{$data->platform}}</td>
                                    <td>{{$data->geo}}</td>
                                    <td>{{$data->service->name}}</td>
                                    <td>{{$data->target_date}}</td>
                                    <td>{{$data->total_quantity}}</td>
                                    <td>{{$data->available_quantity}}</td>
                                    <td>{{$data->service_cost}}</td>
                                    <td>{{$data->total_budget}}</td>
                                    <td>{{$data->perday}}</td>
                                    <td>{{$data->key_word}}</td>
                                    <td>
                                        @foreach ($total as $tData)
                                            @if($tData->o_id == $data->id)
                                               {{$tData->total}}/{{$data->total_quantity}}
                                               @php
                                                    $flag = 0;
                                               @endphp
                                            @endif
                                        @endforeach
                                        @if( $flag == 1)
                                           0/{{$data->total_quantity}}
                                        @endif
                                    </td>
                                    <td>

                                        @if($data->order_status ==1)<span class="textSize badge badge-warning">Pending</span>
                                        @elseif($data->order_status ==2)<span class="textSize badge badge-info">Accept</span>
                                        @elseif($data->order_status ==3)<span class="textSize badge badge-success">In Work</span>
                                        @elseif($data->order_status ==4)<span class="textSize badge badge-warning ">Finished</span>
                                        @elseif($data->order_status ==5)<span class="textSize badge badge-danger">Refilling</span>
                                        @elseif($data->order_status ==6)<span class="textSize badge badge-secondary">Refiled</span>
                                        @elseif($data->order_status ==7)<span class="textSize badge badge-primary">Hold</span>
                                        @elseif($data->order_status ==8)<span class="textSize badge badge-danger">Decline</span>
                                        @elseif($data->order_status ==9)<span class="textSize badge badge-secondary">Active</span>
                                        @elseif($data->order_status ==10)<span class="textSize badge badge-secondary">Completed</span>
                                        @elseif($data->order_status ==11)<span class="textSize badge badge-danger">Canceled</span>
                                        @else<span class="badge">N/A</span>
                                        @endif
                                    </td>

                                    <td>
                                        <input id="exp{{$key+1}}" class="exp"  type="checkbox">
                                        <div class="text">
                                            <label class="btns" for="exp{{$key+1}}"></label>
                                            {{$data->comment}}
                                        </div>
                                    </td>

                                    <td><a href="{{asset('upload/orderFile/'.$data->file)}}" download>Download File</a></td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-info">Action</button>
                                            <button type="button" class="btn btn-info dropdown-toggle dropdown-icon"
                                                data-toggle="dropdown">
                                                <span class="sr-only">Toggle Dropdown</span>
                                            </button>
                                            <div class="dropdown-menu dropdown-content" role="menu">
                                                @if((Auth::user()->role == 1 || Auth::user()->role == 2) &&($data->order_status == 2 || $data->order_status ==3 ||$data->order_status ==9) &&  $data->available_quantity > 0)
                                                <a class="dropdown-item"  data-toggle="modal" data-target="#modal-default"
                                                 onclick="getOrderId({{$data->id}})" ><i
                                                    class="fas fa-check" style="padding-right:10px;"></i> Assign</a>

                                                    @else
                                                    <a class="dropdown-item">NoAction</a>
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
        </div>
    </div>
</section>


<div class="modal fade" id="modal-default">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Assign Order</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col">
                        <form method="post" action="{{url('assign-order')}}" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="order_id" id="id">
                            <div class="row">
                                <div class="col-12">
                                    <div class="row">
                                        <!-- 1st Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Select Vendor/Employee<span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <select name="ven_Emp_id" id="ven_Emp_id" required="" class="form-control select2bs4">
                                                        <option value="" selected="" disabled="">Select Vendor/Employee
                                                        </option>
                                                        @foreach ($workers as $item)
                                                          <option value="{{$item->id}}">{{$item->name}} ~~ {{$item->email}} ~~ @if($item->role == 6) Employee @elseif($item->role == 4) Vendor @endif</option>
                                                        @endforeach

                                                    </select>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 6 -->
                                    </div> <!-- End 1stRow -->

                                    <div class="row" id="calculation">
                                        <!-- 2nd Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Quantity <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number"  name="total_quantity" id="total_quantity" class="form-control" required="">
                                                    <span id='message'></span>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Service Cost(/Work) <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" step="0.0001" name="service_cost" id="service_cost" class="form-control" required="">
                                                    <span id='message2'></span>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 2nd Row -->

                                    <div class="row">
                                        <!-- 3rd Row -->
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Budget <span class="text-danger">*</span></h5>
                                                <div class="controls">
                                                    <input type="number" name="total_budget" id="total_budget" class="form-control" readonly required="">
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <h5>Dalivary Date</h5>
                                                <div class="controls">
                                                    <input type="date" name="target_date" required class="form-control">
                                                    <span id='message3'></span>
                                                </div>
                                            </div>
                                        </div> <!-- End Col md 4 -->
                                    </div> <!-- End 3rd Row -->

                                    <div class="row" style="margin-top: 20px">
                                        <!-- 7TH Row -->
                                        <div class="col-md-5">
                                            <div class="text-xs-right">
                                                <input type="submit" class="btn btn-rounded btn-primary mb-5" value="Submit">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div> <!-- End 7TH Row -->
                                </div>
                            </div>
                        </form>
                    </div>
                    <!-- /.col -->
                </div>
                <!-- /.row -->
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- /.modal -->

<script type="text/javascript">

    $("#calculation").on("keyup click", function()
    {
        var qty = parseFloat($('#total_quantity').val());
        var price = parseFloat($('#service_cost').val());

        var unit_total = parseFloat(qty * price);

        $("#total_budget").val(unit_total.toFixed(2));
    });
</script>

<script>
    function getOrderId(r)
    {
       console.log(r);
       $("#id").val(r);
       var id = r;

       if (id != '') {
            $.ajax({
                url: "findOrderDetailsData",
                method: "GET",
                data: {
                    id: id,
                },
                dataType: "JSON",
                success: function (data)
                {
                    console.log(data);
                    $("#total_quantity").attr({
                    "max" : data.available_quantity,
                    "min" : 1
                    });
                    $('#message').html('Available Work Here - '+data.available_quantity).css('color', 'red');
                    $('#message2').html('Client Rate - '+data.service_cost).css('color', 'red');
                    $('#message3').html('Client Targeted Date - '+data.target_date).css('color', 'red');
                }
            })
        } else {
            alert("Something is wrong ..!!");
        }
    }

</script>
@endsection


@else
    @include('admin.404')
@endif
