@extends('admin.masterBlade')

@section('title')
    Blog Details
@endsection

@section('content')

    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-success table-responsive" style="margin-top:20px;">
                        <div class="card-header text-center">
                            <h5 class="m-0 text-white">Blog Details
                                <a href="{{route('blog.list')}}">
                                    <i class="far fa-arrow-alt-circle-left" style="float: left; font-size:28px;"></i>
                                </a>
                            </h5>
                        </div>
                        
                        <div class="card-body">
                            <div>
                                <h3 style="font-weight: 600;">{{ $blog->title }}</h3>
                                <span><b>Image alt Name:</b> {{ $blog->image_alt_name ?? 'N/A' }}</span> <br />
                                <span><b>Created By:</b> {{ $blog->operator->name }}</span>,
                                <span><b>Date:</b> {{ $blog->created_date }}</span><br/><br/>
                                <img class="img-fluid" style="display: block; margin-left:auto; margin-right:auto;"
                                    src="{{(!empty($blog->image)) ? url('upload/blog/'.$blog->image):url('upload/NoImage.png')}}" 
                                    alt="{{ $blog->image_alt_name ?? 'N/A' }}"><br/>
                                <span>{!! $blog->description !!}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

@endsection
